/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

public class ConnectString {
    private String username;
    private String password;
    private String host;
    private int port;
    private String serviceName;
    private String alias;
    private String protocol;
    private String privilege;

    private ConnectString(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.host = builder.host;
        this.port = builder.port;
        this.serviceName = builder.serviceName;
        this.alias = builder.alias;
        this.protocol = builder.protocol;
        this.privilege = builder.privilege;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.alias != null && !this.alias.isEmpty()) {
            if (this.privilege != null && !this.privilege.isEmpty()) {
                sb.append("\"").append("/@").append(this.alias).append(" as ").append(this.privilege).append("\"");
            } else {
                sb.append("/@").append(this.alias);
            }
            return sb.toString();
        }
        if (this.username != null && !this.username.isEmpty()) {
            sb.append(this.username);
        }
        sb.append("/");
        if (this.password != null && !this.password.isEmpty()) {
            sb.append(this.password);
        }
        if (this.host != null && !this.host.isEmpty() && this.port > 0 && this.serviceName != null && !this.serviceName.isEmpty()) {
            sb.append("@");
            if (this.protocol != null && this.protocol.equalsIgnoreCase("tcps")) {
                sb.append("tcps://");
            }
            sb.append(this.host).append(":").append(this.port).append("/").append(this.serviceName);
        }
        if (this.privilege != null) {
            sb.append(" as ").append(this.privilege);
        }
        return sb.toString();
    }

    public static class Builder {
        private String username;
        private String password;
        private String host;
        private int port;
        private String serviceName;
        private String alias;
        private String protocol;
        private String privilege;

        public Builder() {
        }

        public Builder(String host, int port, String serviceName) {
            this.host = host;
            this.port = port;
            this.serviceName = serviceName;
        }

        public Builder(String username, String password, String serviceName) {
            this.username = username;
            this.password = password;
            this.serviceName = serviceName;
        }

        public Builder(String alias) {
            this.alias = alias;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder privilege(String privilege) {
            this.privilege = privilege;
            return this;
        }

        public ConnectString build() {
            return new ConnectString(this);
        }
    }
}

