/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.completer;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.OCIDatabaseRecoveryClient;
import oracle.dbtools.net.commands.completers.BaseOCICompleter;

public abstract class BaseOCIDatabaseRecoveryCompleter<T>
extends BaseOCICompleter<OCIDatabaseRecoveryClient, OCIDatabaseRecoveryClient.Builder, T> {
    protected final Function<T, String> mapper;

    protected BaseOCIDatabaseRecoveryCompleter(Function<T, String> mapper) {
        this.mapper = mapper;
    }

    public OCIDatabaseRecoveryClient.Builder getClientBuilder(OCIProfile profile, Map<String, Object> transformedOptionsMap) {
        Object endpoint = transformedOptionsMap.get(RCVOptions.ENDPOINT_O.getId().toString());
        OCIDatabaseRecoveryClient.Builder builder = OCIDatabaseRecoveryClient.builder(profile);
        if (endpoint != null) {
            builder.endpoint((String)endpoint);
        }
        return builder;
    }

    protected String mapItem(T item, String prefix) {
        return this.mapper.apply(item);
    }

    protected OCIProfile getProfile(String configPath, String profileName) throws IOException {
        OCIAuthentication authentication = GlobalMetadata.load().getAuthentication();
        return super.getProfile(authentication.getConfigFile(), authentication.getProfileName());
    }
}

