/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.onboarding;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class EncryptionWalletCheck
extends Check {
    private static final String GET_ENCRYPTION_KEY = "select count(*) from v$encryption_keys";
    private static final String GET_ENCRYPTION_WALLET = "select w.inst_id, w.wrl_type, w.wrl_parameter, w.status, w.wallet_type, w.wallet_order, w.con_id, i.host_name from (gv$encryption_wallet w join (select host_name, inst_id from gv$instance) i on w.inst_id = i.inst_id)";
    private Connection conn;
    private ScriptRunnerContext ctx;
    public static final String ID = "encryption_wallet";

    public EncryptionWalletCheck(Connection conn, ScriptRunnerContext ctx) {
        super(conn, "Encryption Key Check", ID);
        this.ctx = ctx;
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        CheckResult encryptionKeyResult = this.checkEncryptionKeys();
        if (encryptionKeyResult.getStatus().equals((Object)CheckResult.Status.FAIL)) {
            return encryptionKeyResult;
        }
        return this.checkEncryptionWallet();
    }

    private CheckResult checkEncryptionKeys() {
        String countInString = DatabaseUtils.queryOneRow(this.conn, GET_ENCRYPTION_KEY);
        try {
            int count = Integer.parseInt(countInString);
            if (count == 0) {
                String message = "No encryption keys found. Backups to the Recovery Service will fail without an encryption key.";
                String actionPlan = "\n\t1. Run the following query to verify the encryption wallet is open and open it if it's closed: select * from v$encryption_wallet;\n\t2. If the encryption wallet is open but there is no master key, please create a TDE master key.\n\t3. If there is no encryption wallet, please configure a TDE wallet.";
                return new CheckResult(CheckResult.Status.FAIL, message, actionPlan);
            }
        }
        catch (NumberFormatException e) {
            return new CheckResult(CheckResult.Status.FAIL, "Failed to check if encryption keys exist: " + e.getMessage());
        }
        return new CheckResult(CheckResult.Status.PASS, "Found encryption keys.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CheckResult checkEncryptionWallet() {
        WorkflowLogger logger = this.getLogger();
        String successMessage = "Encryption wallet is configured correctly.";
        String errorMessage = "Failed to check if encryption wallet is open.";
        int localInstId = DatabaseUtils.getNodeId(this.conn);
        try {
            String conId;
            List<EncryptionWallet> wallets;
            ArrayList<Object> rows;
            block22: {
                ResultSet rs = DBUtil.getInstance((Connection)this.conn).executeOracleQuery(GET_ENCRYPTION_WALLET, null);
                if (rs != null) {
                    Object encWallet2;
                    rows = new ArrayList<Object>();
                    int numRows = 0;
                    while (rs.next()) {
                        ++numRows;
                        encWallet2 = new EncryptionWallet();
                        ((EncryptionWallet)encWallet2).instId = Integer.parseInt(rs.getString("INST_ID"));
                        ((EncryptionWallet)encWallet2).hostName = rs.getString("HOST_NAME");
                        ((EncryptionWallet)encWallet2).status = rs.getString("STATUS");
                        ((EncryptionWallet)encWallet2).conId = rs.getString("CON_ID");
                        ((EncryptionWallet)encWallet2).walletOrder = rs.getString("WALLET_ORDER");
                        ((EncryptionWallet)encWallet2).wrlParameter = rs.getString("WRL_PARAMETER");
                        ((EncryptionWallet)encWallet2).wrlType = rs.getString("WRL_TYPE");
                        rows.add(encWallet2);
                    }
                    if (numRows == 0) {
                        encWallet2 = new CheckResult(CheckResult.Status.FAIL, "No encryption wallet found.", "Please verify you have a TDE wallet configured.");
                        return encWallet2;
                    }
                    List rowsWithAsmWallets = rows.stream().filter(encWallet -> encWallet.wrlType != null && encWallet.wrlType.equalsIgnoreCase("ASM") && encWallet.walletOrder != null && !encWallet.walletOrder.equals("SECONDARY")).collect(Collectors.toList());
                    if (!rowsWithAsmWallets.isEmpty()) {
                        CheckResult checkResult = new CheckResult(CheckResult.Status.FAIL, "ASM wallets are not supported.", "Please configure the TDE wallet using ACFS, regular file system, or external keystore manager like OKV or OCI KMS.");
                        return checkResult;
                    }
                    break block22;
                } else {
                    logger.log(Level.FINE, errorMessage);
                    CheckResult checkResult = new CheckResult(CheckResult.Status.FAIL, errorMessage, "Please try rerunning the check.");
                    return checkResult;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            Map<Integer, List<EncryptionWallet>> encWalletsPerNode = rows.stream().collect(Collectors.groupingBy(encWallet -> encWallet.instId));
            Object object = encWalletsPerNode.keySet().iterator();
            block13: while (true) {
                boolean isOpen;
                List invalidWalletPaths;
                if (!object.hasNext()) {
                    object = new CheckResult(CheckResult.Status.PASS, successMessage);
                    return object;
                }
                int instId = object.next();
                List<EncryptionWallet> encWallets = encWalletsPerNode.get(instId);
                if (instId == localInstId && !(invalidWalletPaths = encWallets.stream().filter(wallet -> wallet.wrlParameter != null && wallet.wrlType != null && wallet.walletOrder != null && wallet.wrlType.equalsIgnoreCase("FILE") && !wallet.walletOrder.equalsIgnoreCase("SECONDARY") && !Files.exists(Paths.get(wallet.wrlParameter, new String[0]), new LinkOption[0])).map(wallet -> wallet.wrlParameter).collect(Collectors.toList())).isEmpty()) {
                    String message = String.format("The following wallet(s) do not exist: %s", String.join((CharSequence)", ", invalidWalletPaths));
                    CheckResult checkResult = new CheckResult(CheckResult.Status.FAIL, message, "Please create this wallet if it does not exist.");
                    return checkResult;
                }
                Map<String, List<EncryptionWallet>> encWalletsPerContainer = encWallets.stream().collect(Collectors.groupingBy(wallet -> wallet.conId));
                Iterator<String> iterator = encWalletsPerContainer.keySet().iterator();
                do {
                    if (!iterator.hasNext()) continue block13;
                } while (isOpen = (wallets = encWalletsPerContainer.get(conId = iterator.next())).stream().anyMatch(wallet -> wallet.status != null && wallet.walletOrder != null && (wallet.status.equalsIgnoreCase("OPEN") || wallet.status.equalsIgnoreCase("OPEN_UNKNOWN_MASTER_KEY_STATUS")) && !wallet.walletOrder.equalsIgnoreCase("SECONDARY")));
                break;
            }
            String msg = String.format("%s %s's wallet on node %s is not open", conId.equals("1") ? "CDB" : "PDB", conId, wallets.get((int)0).hostName);
            String actionPlan = "\n\t1. Please open the wallet(s).\n\t2. Please execute the following SQL query and verify the status is 'OPEN' for the container database and all pluggable databases: select * from gv$encryption_wallet;";
            CheckResult checkResult = new CheckResult(CheckResult.Status.FAIL, msg, actionPlan);
            return checkResult;
        }
        catch (SQLException e) {
            logger.getLogger().log(Level.FINE, errorMessage, e);
            return new CheckResult(CheckResult.Status.FAIL, errorMessage + " " + e.getMessage());
        }
    }

    private static class EncryptionWallet {
        private int instId;
        private String hostName;
        private String wrlType;
        private String wrlParameter;
        private String status;
        private String walletOrder;
        private String conId;

        private EncryptionWallet() {
        }
    }
}

