/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.onboarding;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;

public class ArchiveLogModeCheck
extends Check {
    public static final String ID = "archive_log_mode";
    private Connection conn;

    public ArchiveLogModeCheck(Connection conn) {
        super(conn, "Archive Log Mode Check", ID);
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        String mode = DatabaseUtils.getArchiveLogMode(this.conn);
        if (mode.equalsIgnoreCase("ARCHIVELOG")) {
            return new CheckResult(CheckResult.Status.PASS, "Database is configured to archive redo logs.");
        }
        return new CheckResult(CheckResult.Status.FAIL, "Database is not configured to archive redo logs.", "Please update the database log_mode to archivelog to enable archival of redo logs.");
    }
}

