/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.health;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class RCVConnectivityCheck
extends Check {
    private Connection conn;
    public static final String NAME = "Connectivity to Recovery Service Catalog";
    public static final String ID = "catalog_connectivity";
    private WorkflowLogger logger;

    public RCVConnectivityCheck(Connection conn) {
        super(conn, NAME, ID);
        this.conn = conn;
        this.logger = this.getLogger();
    }

    @Override
    public CheckResult run() {
        Database database = RCVCommandBase.getDatabase(this.conn);
        ProtectedDatabaseCache protectedDatabaseCache = database.getFleetAgentContext().getProtectedDatabaseCache();
        if (database.getOcid() != null) {
            try {
                FleetEngine.getEngineConnection(database.getFleetAgentContext().getTnsAdmin(), protectedDatabaseCache.getWalletLocation(), protectedDatabaseCache.getCredentialAlias());
            }
            catch (Exception e) {
                String error = String.format("This database cannot connect to the Recovery Service catalog: %s", e.getMessage());
                return new CheckResult(CheckResult.Status.FAIL, error);
            }
            return new CheckResult(CheckResult.Status.PASS, "Recovery Service is reachable.");
        }
        return new CheckResult(CheckResult.Status.SKIPPED, "Database is not onboarded to Recovery Service. Skipping check.");
    }
}

