/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.LogManager;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public abstract class Check {
    private String name;
    private String id;
    private CheckResult.Status status;
    private WorkflowLogger logger;
    private Connection conn;
    private boolean runOnRemoteNodes;

    public Check(Connection conn, String name, String id) {
        this(conn, name, id, false);
    }

    public Check(Connection conn, String name, String id, boolean runOnRemoteNodes) {
        this.conn = conn;
        this.name = name;
        this.id = id;
        this.runOnRemoteNodes = runOnRemoteNodes;
    }

    public abstract CheckResult run();

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean getRunOnRemoteNodes() {
        return this.runOnRemoteNodes;
    }

    public CheckResult.Status getStatus() {
        return this.status;
    }

    public WorkflowLogger getLogger() {
        if (this.logger == null) {
            String logFile = LogManager.getLogFile(this.id, DatabaseUtils.getDbUniqueName(this.conn));
            this.logger = LogManager.getLogger(logFile);
        }
        return this.logger;
    }

    public void setLogger(WorkflowLogger logger) {
        this.logger = logger;
    }
}

