/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.task;

import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;

public class TransferTaskByteProgressMonitor
extends TransferTaskProgressMonitor {
    RaptorTask<?> task;
    public volatile long written;
    public long start;
    public long reportByteInterval;
    public volatile long prevReportedByte;

    public TransferTaskByteProgressMonitor(RaptorTask<?> theTask, long theReportByteInterval) {
        super(null);
        this.task = theTask;
        this.reportByteInterval = theReportByteInterval;
    }

    @Override
    public void init(int op, String source, String target, long max) {
        if (this.start == 0L) {
            this.prevReportedTime = this.start = System.nanoTime();
        }
    }

    @Override
    public boolean count(long count) {
        boolean ok = true;
        this.written += count;
        if (this.written >= this.prevReportedByte + this.reportByteInterval) {
            this.showStatus();
        }
        return ok;
    }

    @Override
    public void end() {
        this.showStatus();
    }

    protected void showStatus() {
        this.task.setMessage(this.getStatus());
    }

    protected String getStatus() {
        long now = System.nanoTime();
        double elapsedT = (double)(now - this.start) / 1.0E9;
        double sizeT = (double)this.written / 1048576.0;
        double rateT = sizeT / elapsedT;
        String format = "%sMiB / %ss = %s MiB/s";
        String msg = String.format(format, this.df.format(sizeT), this.df.format(elapsedT), this.df.format(rateT));
        this.prevReportedTime = now;
        this.prevReportedByte = this.written;
        return msg;
    }
}

