/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.file;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;

public class FileSet {
    private List<Path> paths = new ArrayList<Path>();
    private Location location;
    private long totalSize;
    private static Comparator<FileInfo> fileInfoSizeComparator = new Comparator<FileInfo>(){

        @Override
        public int compare(FileInfo o1, FileInfo o2) {
            if (o1.getLength() < o2.getLength()) {
                return -1;
            }
            if (o1.getLength() > o2.getLength()) {
                return 1;
            }
            return 0;
        }
    };
    private List<FileInfo> fileInfos = new ArrayList<FileInfo>();

    public FileSet() {
    }

    public FileSet(Location location, Collection<String> files) {
        this.setLocation(location);
        for (String file : files) {
            this.add(file);
        }
    }

    public void add(String path) {
        this.paths.add(Paths.get(path, new String[0]));
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public long getTotalSize() {
        if (0L == this.totalSize) {
            for (Path path : this.getPaths()) {
                this.totalSize += path.toFile().length();
            }
        }
        return this.totalSize;
    }

    public List<FileInfo> getFileInfos(Location targetLocation, String targetDir) {
        if (this.fileInfos.isEmpty()) {
            for (Path path : this.getPaths()) {
                FileInfo fileInfo = new FileInfo(path, this.getLocation(), targetLocation, targetDir);
                this.fileInfos.add(fileInfo);
            }
            FileInfo[] array = this.fileInfos.toArray(new FileInfo[0]);
            Arrays.sort(array, fileInfoSizeComparator);
            this.fileInfos.clear();
            this.fileInfos.addAll(Arrays.asList(array));
        }
        return this.fileInfos;
    }

    public String asJson() {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\"fileInfos\":[\n");
        String indent = "   ";
        boolean firstInfo = true;
        for (FileInfo info : this.fileInfos) {
            String[] lines;
            int pfx = firstInfo ? 32 : 44;
            for (String line : lines = info.asJson().split("\n")) {
                sb.append(indent).append((char)pfx).append(line).append('\n');
                pfx = 32;
            }
            firstInfo = false;
        }
        sb.append("]}");
        return sb.toString();
    }
}

