/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.awrash.command;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.BiConsumer;
import oracle.dbtools.extension.awrash.command.AWRMessages;
import oracle.dbtools.extension.awrash.core.AWREngine;
import oracle.dbtools.extension.awrash.exception.NoPrivilegesAvailableException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;

class CreateSnapshotAction
implements BiConsumer<ScriptRunnerContext, Connection> {
    private final String flushlevel;

    CreateSnapshotAction(Node rawValue, TransformContext context, Environment environment) {
        String flush = (String)((Node)rawValue.getChildNodes().get(2)).getValue();
        this.flushlevel = flush != null ? flush : "";
    }

    @Override
    public void accept(ScriptRunnerContext context, Connection connection) {
        AWREngine awrEngine = new AWREngine(context, connection);
        Optional<Object> snapId = Optional.empty();
        try {
            snapId = awrEngine.createSnapshot(this.flushlevel);
        }
        catch (NoPrivilegesAvailableException e) {
            context.writeln(e.getMessage());
        }
        if (snapId.isEmpty()) {
            context.writeln(AWRMessages.getString("AWR_ERROR_CREATE_SNAPSHOT"));
            return;
        }
        context.writeln(MessageFormat.format(AWRMessages.getString("AWR_SNAPSHOT_TAKEN"), snapId.get()));
    }
}

