/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import com.healthmarketscience.jackcess.Table;
import java.util.Map;
import net.ucanaccess.commands.UpdateCommand;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.triggers.TriggerBase;
import net.ucanaccess.triggers.TriggerException;
import net.ucanaccess.util.Try;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.types.BlobData;

public class TriggerUpdate
extends TriggerBase {
    public void fire(int type, String name, String tableName, Object[] oldR, Object[] newR) {
        this.checkContext();
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        if (conn.isFeedbackState()) {
            return;
        }
        String execId = UcanaccessConnection.getCtxExcId();
        Try.catching(() -> {
            Table t = this.getTable(tableName, conn);
            this.fillBlobs(oldR);
            this.fillBlobs(newR);
            super.convertRowTypes(oldR, t);
            super.convertRowTypes(newR, t);
            if (this.valuesChanged(oldR, newR)) {
                Map<String, Object> rowPattern = this.getRowPattern(oldR, t);
                UpdateCommand c4j = new UpdateCommand(t, rowPattern, newR, execId);
                conn.add(c4j);
            }
        }).orThrow(ex -> new TriggerException(ex.getMessage()));
    }

    public boolean valuesChanged(Object[] oldR, Object[] newR) {
        if (oldR.length != newR.length) {
            return true;
        }
        int i = 0;
        while (i < oldR.length) {
            if (oldR[i] == null ^ newR[i] == null) {
                return true;
            }
            if (oldR[i] != null && newR[i] != null && !oldR[i].equals(newR[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fillBlobs(Object[] _values) throws UcanaccessSQLException {
        int i = 0;
        while (i < _values.length) {
            Object value = _values[i];
            if (value instanceof BlobData) {
                BlobKey bk;
                long length;
                BlobData bd = (BlobData)value;
                JDBCConnection hsqlConn = (JDBCConnection)UcanaccessConnection.getCtxConnection().getHSQLDBConnection();
                SessionInterface si = hsqlConn.getSession();
                byte[] bt = ((BlobData)value).getBytes(si, 0L, (int)(length = bd.length(si)));
                _values[i] = bt.length == 0 ? (Object)bt : ((bk = BlobKey.getBlobKey(bt)) == null ? (Object)bt : bk.getOleBlob(UcanaccessConnection.getCtxConnection().getDbIO()));
            }
            ++i;
        }
    }
}

