/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.apexlang.APEXAppFile;
import oracle.apexlang.FileLoader;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.apexlang.core.APEXLangSuggestion;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.APEXLangWarning;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.Location;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Property;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangTranspiler;

public class APEXLangApplicationState {
    private static final APEXAppFile EMPTY_APEX_APP_FILE = new APEXAppFile("");
    private final Path rootPath;
    private BigDecimal applicationId;
    private final APEXLangTranspiler apexLangTranspiler;
    private final APEXLangCompilerContext apexLangCompilerContext;

    public APEXLangApplicationState(Path rootPath) {
        this.rootPath = rootPath;
        this.apexLangTranspiler = new APEXLangTranspiler();
        this.applicationId = null;
        if (rootPath != null) {
            Map<String, APEXAppFile> fileMap = this.getApplicationFileMap(null);
            this.processManifest(fileMap);
            this.apexLangCompilerContext = this.apexLangTranspiler.getCompiler().getCompilerContext(fileMap);
        } else {
            this.apexLangCompilerContext = new APEXLangCompilerContext();
        }
    }

    public Map<String, APEXAppFile> getApplicationFileMap(Map<URI, String> openFiles) {
        FileLoader fileLoader = new FileLoader();
        HashMap<String, APEXAppFile> fileMap = new HashMap();
        try {
            fileMap = fileLoader.getFilesFromDirectory(this.rootPath.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashMap<String, APEXAppFile> finalMap = fileMap;
        if (openFiles != null) {
            openFiles.forEach((uri, source) -> {
                String osIndepPath = Path.of(uri).toUri().getPath();
                String osIndepRoot = this.rootPath.toUri().getPath();
                String key = osIndepPath.substring(osIndepRoot.length());
                finalMap.put(key, new APEXAppFile(source));
            });
        }
        return fileMap;
    }

    public APEXLangCompilationResult compileApplication(Map<URI, String> openFiles) {
        return this.apexLangTranspiler.transpile(this.getApplicationFileMap(openFiles), new APEXLangCompilerContext());
    }

    public APEXLangCompilationResult compile(URI uri, String source, System.Logger logger) {
        APEXLangCompilationResult result;
        block4: {
            String relativePath = this.getRelativeFilePath(uri.getPath());
            HashMap<String, APEXAppFile> fileMap = new HashMap<String, APEXAppFile>();
            try {
                this.addNonApexFiles(fileMap, this.rootPath);
                this.processManifest(fileMap);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            fileMap.put(relativePath, new APEXAppFile(source));
            try {
                result = this.apexLangTranspiler.transpile(fileMap, this.apexLangCompilerContext);
            }
            catch (Exception e) {
                result = new APEXLangCompilationResult(null, new APEXLangSyntaxError[0], new APEXLangWarning[0], (Collection)Collections.EMPTY_LIST);
                if (logger == null) break block4;
                logger.log(System.Logger.Level.ERROR, e);
            }
        }
        return result;
    }

    private String getRelativeFilePath(String uri) {
        String root = this.rootPath.toUri().getPath();
        if (uri.startsWith(root)) {
            return uri.substring(root.length());
        }
        return uri;
    }

    public URI getUri(String relativeFilePath) {
        if (this.rootPath != null) {
            return this.rootPath.resolve(relativeFilePath).toUri();
        }
        return null;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public List<String> getAvailableReferences(Property property, ComponentParameter componentParameter) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(componentParameter);
        return this.apexLangTranspiler.getCompiler().getAvailableReferences(property, componentParameter.getComponent(), this.apexLangCompilerContext);
    }

    public Location getReferenceLocation(Property property, ComponentParameter componentParameter) {
        if (property != null && componentParameter != null) {
            Location loc;
            Object reference = componentParameter.getValue();
            if (reference != null && !((String)reference).startsWith("@")) {
                reference = "@" + (String)reference;
            }
            if ((loc = this.apexLangTranspiler.getCompiler().getReferenceLocation(property, componentParameter.getComponent(), this.apexLangCompilerContext, (String)reference)) != null) {
                return new Location(this.getUri(loc.getFilePath()).toString(), loc.getPostion());
            }
        }
        return null;
    }

    public List<ComponentType> getAvailableChildComponentTypes(Component component) {
        Metametadata mmd = this.getMetaMetaData();
        ArrayList<ComponentType> ret = new ArrayList<ComponentType>();
        String parentComponentTypeId = component.getTypeId();
        if (parentComponentTypeId != null) {
            for (Map.Entry entry : mmd.getComponentTypes().entrySet()) {
                ComponentType componentType = (ComponentType)entry.getValue();
                ComponentType.Parent parent = componentType.getParent();
                if (parent == null || !parentComponentTypeId.equals(parent.getComponentTypeId())) continue;
                ret.add(componentType);
            }
        }
        return ret;
    }

    public List<Property> getAvailableProperties(Component component) {
        Metametadata mmd = this.getMetaMetaData();
        Set setPropIds = component.getParameters().keySet();
        ComponentType componentType = (ComponentType)mmd.getComponentTypes().get(component.getTypeId());
        Set availablePropIds = componentType.getProperties().keySet();
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Map.Entry entry : mmd.getProperties().entrySet()) {
            if (!availablePropIds.contains(entry.getKey()) || setPropIds.contains(entry.getKey())) continue;
            ret.add((Property)entry.getValue());
        }
        return ret;
    }

    public List<APEXLangSuggestion> getSuggestions(URI uri, String source, int offset) {
        HashMap<String, APEXAppFile> fileMap = new HashMap<String, APEXAppFile>();
        String relativePath = this.getRelativeFilePath(uri.getPath());
        fileMap.put(relativePath, new APEXAppFile(source));
        try {
            this.addNonApexFiles(fileMap, this.rootPath);
            this.processManifest(fileMap);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        List suggestions = this.apexLangTranspiler.getCompiler().getSuggestions(fileMap, this.apexLangCompilerContext, relativePath, offset);
        if (suggestions == null) {
            return List.of();
        }
        return suggestions;
    }

    public BigDecimal getApplicationId() {
        return this.applicationId;
    }

    public Metametadata getMetaMetaData() {
        return this.apexLangTranspiler.getMetaMetaData();
    }

    private void addNonApexFiles(Map<String, APEXAppFile> fileMap, Path path) throws IOException {
        try (Stream<Path> stream = Files.list(path);){
            for (Path childPath : stream.collect(Collectors.toList())) {
                if (Files.isDirectory(childPath, new LinkOption[0])) {
                    this.addNonApexFiles(fileMap, childPath);
                    continue;
                }
                String relativePath = this.getRelativeFilePath(childPath.toString());
                if (relativePath.equals("config.json")) {
                    fileMap.put(relativePath, new APEXAppFile(Files.readString(childPath)));
                    continue;
                }
                if (relativePath.endsWith(".apex")) continue;
                fileMap.put(relativePath, EMPTY_APEX_APP_FILE);
            }
        }
    }

    private void processManifest(Map<String, APEXAppFile> fileMap) {
        this.applicationId = null;
        if (fileMap.containsKey("config.json")) {
            try {
                String configContent = fileMap.get("config.json").getContentString();
                APEXLangManifestObject manifestObject = (APEXLangManifestObject)JSON.std.beanFrom(APEXLangManifestObject.class, (Object)configContent);
                if (manifestObject != null && manifestObject.getApp_id() != null) {
                    this.applicationId = new BigDecimal(manifestObject.getApp_id());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

