/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangManifestGenerator;
import oracle.dbtools.extension.apex.exceptions.ApexQueryException;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.APEXLangUtils;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.extension.apex.utility.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import org.apache.commons.io.FileUtils;

public class APEXExport {
    private static final String BLOB_QUERIES_SUFFIX = "_blob";
    private final Map<String, RowDetails> _clobData = new LinkedHashMap<String, RowDetails>();
    private final MutableCommand _command;
    private final boolean _noFileStoreClob;
    private ScriptRunnerContext _ctx;
    private OutputStream _out;
    private Connection _gConn;
    private int apexApiVersion;

    @Deprecated(since="25.3.0")
    public APEXExport(MutableCommand mutableCommand) {
        this(mutableCommand, false);
    }

    @Deprecated(since="25.3.0")
    public APEXExport(MutableCommand mutableCommand, boolean noFileStoreClob) {
        this._command = mutableCommand;
        this._noFileStoreClob = noFileStoreClob;
    }

    public APEXExport(MutableCommand command, ScriptRunnerContext context, Connection conn) {
        this(command, context, conn, false);
    }

    public APEXExport(MutableCommand command, ScriptRunnerContext context, Connection conn, boolean noFileStoreClob) {
        this._noFileStoreClob = noFileStoreClob;
        this._command = command;
        this._ctx = context;
        this._gConn = conn;
        this.apexApiVersion = this.getApiVersion(this._gConn);
        this._out = this._ctx.getOutputStream();
    }

    private void write(Object o) throws IOException {
        Objects.requireNonNull(this._out, "OutputStream Buffer is not initialized");
        this._out.write(o.toString().getBytes(StandardCharsets.UTF_8));
        this._out.write("\n".getBytes(StandardCharsets.UTF_8));
        this._out.flush();
    }

    public void doCapture() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized, AppNotInstalledException, ApexQueryException {
        if (this.getBool(ApexOptions.Symbol.EXPWORKSPACE)) {
            if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
                this.exportWorkspace();
            } else {
                this.exportAllWorkspaces();
            }
        } else if (this.getBool(ApexOptions.Symbol.EXPFEEDBACK)) {
            this.exportFeedback();
        } else if (this.getBool(ApexOptions.Symbol.EXPFILES)) {
            this.exportStaticFiles();
        } else if (this.getBool(ApexOptions.Symbol.INSTANCE)) {
            this.exportInstance();
        } else if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
            this.exportAllApplications();
        } else {
            this.exportApplication(false);
        }
    }

    public void exportAllApplications() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized, AppNotInstalledException, ApexQueryException {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_ALL_APPLICATIONS.toString());
        }
        if (null == this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_WORKSPACE"));
        }
        try (PreparedStatement stmt = this._gConn.prepareStatement(QueryUtils.getXMLQueries().getQuery("gStmt2", this._gConn).getSql());){
            stmt.setBigDecimal(1, this.getDec(ApexOptions.Symbol.WORKSPACEID));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                this._command.setOptionValue(ApexOptions.Symbol.APPLICATIONID, result.getBigDecimal(1));
                this.exportApplication(true);
            }
            result.close();
        }
    }

    public void exportAllWorkspaces() throws SQLException, IOException {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_ALL_WORKSPACES.toString());
        }
        try (PreparedStatement stmt = this._gConn.prepareStatement(QueryUtils.getXMLQueries().getQuery("gStmtWorkspaces", this._gConn).getSql());
             ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                BigDecimal wkspID = result.getBigDecimal(1);
                String wkspName = result.getString(2);
                this._command.setOptionValue(ApexOptions.Symbol.WORKSPACEID, wkspID);
                this._command.setOptionValue(ApexOptions.Symbol.WORKSPACENAME, wkspName);
                this.exportWorkspace();
            }
        }
    }

    public void exportComponents() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized, AppNotInstalledException, ApexQueryException {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_COMPONENTS.toString());
        }
        this.exportApplication(false);
    }

    private String getString(Id id) {
        return (String)this._command.getOptionValue(id);
    }

    public void exportApplication(boolean expPkgAppMapping) throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized, AppNotInstalledException, ApexQueryException {
        String manifestPath;
        if (!this.isExportFormatTypeSupported()) {
            throw new InvalidApexExportException(ApexMessages.getString("EXP_TYPE_FORMAT_NOT_SUPPORTED"));
        }
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_APPLICATION.toString());
        }
        if (null == this.getDec(ApexOptions.Symbol.APPLICATIONID)) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_APPLICATION_ID"));
        }
        QueryUtils.loadAppDetail(this._gConn, this._command, this.getDec(ApexOptions.Symbol.APPLICATIONID));
        this.write(ApexMessages.format("EXPORT_APPLICTION", this.getString(ApexOptions.Symbol.WORKSPACENAME), this.getDec(ApexOptions.Symbol.APPLICATIONID).toString(), this.getString(ApexOptions.Symbol.APPLICATIONNAME)));
        if (this.apexApiVersion == 0) {
            this.apexApiVersion = this.getApiVersion(this._gConn);
        }
        String p_stmt = QueryUtils.getXMLQueries().getQuery("apex.export.v" + this.apexApiVersion, this._gConn).getSql();
        OracleCallableStatement l_stmt = this.getExportStmt(p_stmt);
        l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.APPLICATIONID));
        this.bind_yn(l_stmt, 3, this.getBool(ApexOptions.Symbol.SPLIT));
        this.bind_yn(l_stmt, 4, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
        this.bind_yn(l_stmt, 5, this.getBool(ApexOptions.Symbol.EXPPUBREPORTS));
        this.bind_yn(l_stmt, 6, this.getBool(ApexOptions.Symbol.EXPSAVEDREPORTS));
        this.bind_yn(l_stmt, 7, this.getBool(ApexOptions.Symbol.EXPIRNOTIF));
        this.bind_yn(l_stmt, 8, this.getBool(ApexOptions.Symbol.EXPTRANSLATIONS));
        this.bind_yn(l_stmt, 9, expPkgAppMapping);
        this.bind_yn(l_stmt, 10, this.getBool(ApexOptions.Symbol.EXPORIGINALIDS));
        this.bind_yn(l_stmt, 11, this.getBool(ApexOptions.Symbol.EXPNOSUBSCRIPTIONS));
        this.bind_yn(l_stmt, 12, this.getBool(ApexOptions.Symbol.EXPCOMMENTS));
        l_stmt.setString(13, this.getString(ApexOptions.Symbol.EXPSUPPORTINGOBJECTS));
        this.bind_yn(l_stmt, 14, this.getBool(ApexOptions.Symbol.EXPACLASSIGNMENTS));
        if (1 < this.apexApiVersion) {
            if (null != this.getString(ApexOptions.Symbol.EXPCOMPONENTS)) {
                String cleaned = this.getString(ApexOptions.Symbol.EXPCOMPONENTS).replaceAll("^\"|\"$", "");
                l_stmt.setString(15, cleaned);
            } else {
                l_stmt.setString(15, "");
            }
        }
        if (2 < this.apexApiVersion) {
            l_stmt.setString(16, this.getListAsString(ApexOptions.Symbol.EXPTYPE));
        }
        if (3 < this.apexApiVersion) {
            String auditTypeVal = this.getString(ApexOptions.Symbol.AUDITTYPE);
            if (auditTypeVal != null && auditTypeVal.equalsIgnoreCase("NULL")) {
                l_stmt.setNull(17, 0);
            } else {
                l_stmt.setString(17, auditTypeVal);
            }
        }
        if (4 < this.apexApiVersion) {
            Array options = this.getOptionsListAsArray(ApexOptions.Symbol.EXPRUNTIMEINSTANCES);
            if (null != options) {
                l_stmt.setArray(18, options);
            } else {
                l_stmt.setNull(18, 2003, "WWV_FLOW_T_VARCHAR2");
            }
        }
        this.handleWriteOrSave(l_stmt);
        if (ApexOptions.isAPEXLangEnabled() && this.isAPEXlangExport() && !Files.exists(Paths.get(manifestPath = this.getExportFileLocation("config.json"), new String[0]), new LinkOption[0])) {
            APEXLangManifestGenerator generator = APEXLangManifestGenerator.builder().applicationId(this.getDec(ApexOptions.Symbol.APPLICATIONID)).workspaceId(this.getDec(ApexOptions.Symbol.WORKSPACEID)).setFromConnection(this._gConn).build();
            APEXLangManifestObject manifestObject = generator.generate();
            boolean overWrite = this.getBool(ApexOptions.Symbol.OVERWRITE_FILES);
            File manifestFile = ApexUtil.getFile(this._ctx, manifestPath.toString(), true, overWrite);
            JSON.std.with(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT}).write((Object)manifestObject, manifestFile);
        }
    }

    private BigDecimal getDec(Id id) {
        return (BigDecimal)this._command.getOptionValue(id);
    }

    private int getApiVersion(Connection conn) {
        String version = DBUtil.getInstance((Connection)conn).executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        if (null == version) {
            return 1;
        }
        String cleanVersion = version.replace("-", "");
        Version source = new Version(cleanVersion);
        if (source.compareTo(new Version("25.1")) >= 0) {
            return 5;
        }
        if (source.compareTo(new Version("24.1")) >= 0) {
            return 4;
        }
        if (source.compareTo(new Version("20.2")) >= 0) {
            return 3;
        }
        if (source.compareTo(new Version("19.2")) >= 0) {
            return 2;
        }
        return 1;
    }

    private OracleCallableStatement getExportStmt(String statement) throws SQLException {
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            try {
                this.write("  " + statement.replace("\n", "\n  "));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OracleCallableStatement callableStatement = (OracleCallableStatement)this._gConn.prepareCall(statement);
        if (this.isBlobSupported()) {
            callableStatement.registerOutParameter(1, 2004);
        } else {
            callableStatement.registerOutParameter(1, 2003, ApexUtil.getApexSchema(this._gConn) + ".WWV_FLOW_T_EXPORT_FILES");
        }
        return callableStatement;
    }

    private void bind_yn(OracleCallableStatement p_stmt, int p_pos, boolean p_val) throws SQLException {
        p_stmt.setString(p_pos, p_val ? "Y" : "N");
    }

    private boolean getBool(Id id) {
        return this._command.isFlagSet(id);
    }

    private String getListAsString(Id id) {
        Object val = this._command.getOptionValue(id);
        if (val instanceof List) {
            int s = ((Collection)val).size();
            if (1 == s) {
                return (String)((List)val).get(0);
            }
            if (1 < s) {
                return String.join((CharSequence)",", (Iterable)val);
            }
            return null;
        }
        if ("[APPLICATION_SOURCE]".equals(val.toString())) {
            return "APPLICATION_SOURCE";
        }
        return null;
    }

    private Array getOptionsListAsArray(Id id) throws SQLException {
        Object val = this._command.getOptionValue(id);
        if (null == val) {
            return null;
        }
        if (val instanceof List) {
            ARRAY itemsArray = null;
            List itemsList = (List)val;
            if (!itemsList.isEmpty()) {
                if (1 == itemsList.size() && ((String)itemsList.get(0)).equals("NULL")) {
                    return null;
                }
                itemsArray = this._gConn.unwrap(OracleConnection.class).createARRAY("WWV_FLOW_T_VARCHAR2", (Object)itemsList.toArray(new String[0]));
            }
            return itemsArray;
        }
        return null;
    }

    private void handleWriteOrSave(OracleCallableStatement p_stmt) throws SQLException, IOException {
        if (this._noFileStoreClob) {
            this.executeAndSaveResult(p_stmt);
        } else {
            this.executeAndWriteFiles(p_stmt);
        }
    }

    private boolean isAPEXlangExport() {
        Object expType = this._command.getOptionValue(ApexOptions.Symbol.EXPTYPE);
        if (expType != null) {
            return this.getListAsString(ApexOptions.Symbol.EXPTYPE).contains("APEXLANG");
        }
        return false;
    }

    private boolean isExportFormatTypeSupported() {
        String expTypes = this.getListAsString(ApexOptions.Symbol.EXPTYPE);
        if (expTypes.contains("APEXLANG") || expTypes.contains("SQL")) {
            this.apexApiVersion = this.getApiVersion(this._gConn);
            return this.getApiVersion(this._gConn) >= 5;
        }
        return true;
    }

    private boolean isAppExport() {
        String exportType = this.getString(ApexOptions.Symbol.EXPORT_TYPE);
        if (null != exportType && !"".equals(exportType)) {
            return ApexOptions.Symbol.EXPORT_APPLICATION.toString().equals(exportType) || ApexOptions.Symbol.EXPORT_ALL_APPLICATIONS.toString().equals(exportType) || ApexOptions.Symbol.EXPORT_INSTANCE.toString().equals(exportType) || ApexOptions.Symbol.EXPORT_COMPONENTS.toString().equals(exportType);
        }
        return false;
    }

    private boolean isComponentExport() {
        if (null != this.getString(ApexOptions.Symbol.EXPCOMPONENTS)) {
            return true;
        }
        String exportType = this.getString(ApexOptions.Symbol.EXPORT_TYPE);
        if (null != exportType && !"".equals(exportType)) {
            return ApexOptions.Symbol.EXPORT_COMPONENTS.toString().equals(exportType);
        }
        return false;
    }

    private String getExportFileParentDirectories() {
        return this.getString(ApexOptions.Symbol.ALIAS).toLowerCase();
    }

    private String getExportFileLocation(String filePath) {
        Object newFilePath = filePath;
        if (ApexOptions.isAPEXLangEnabled() && this.isAPEXlangExport() && this.isAppExport()) {
            if (((String)newFilePath).startsWith("application/")) {
                newFilePath = ((String)newFilePath).replaceFirst("application/", "");
            }
            newFilePath = this.getExportFileParentDirectories() + "/" + (String)newFilePath;
        }
        if (null != this.getString(ApexOptions.Symbol.DIR) && !"".equals(this.getString(ApexOptions.Symbol.DIR))) {
            newFilePath = this.getString(ApexOptions.Symbol.DIR).replaceAll("/$", "") + "/" + (String)newFilePath;
        }
        return newFilePath;
    }

    private void executeAndSaveResult(OracleCallableStatement p_stmt) throws IOException, SQLException {
        java.util.Date now;
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            this.write("  Start " + String.valueOf(now));
        }
        p_stmt.execute();
        if (this.isBlobSupported()) {
            this.saveBlobResult(p_stmt);
        } else {
            this.saveClobResult(p_stmt);
        }
        p_stmt.close();
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            this.write("  Completed at " + String.valueOf(now));
        }
    }

    private void saveBlobResult(OracleCallableStatement stmt) throws IOException, SQLException {
        try (InputStream export = stmt.getBLOB(1).getBinaryStream();
             ZipInputStream zipInputStream = new ZipInputStream(export);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    int count;
                    String name = entry.getName();
                    byte[] buffer = new byte[1024];
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, count);
                    }
                    this._clobData.put(name, new RowDetails(name, baos.toString(), ((Serializable)((Object)Objects.requireNonNullElse(this.getDec(ApexOptions.Symbol.APPLICATIONID), ""))).toString(), ((Serializable)((Object)Objects.requireNonNullElse(this.getDec(ApexOptions.Symbol.WORKSPACEID), ""))).toString(), this.getString(ApexOptions.Symbol.APPLICATIONNAME), this.getString(ApexOptions.Symbol.WORKSPACENAME), this.getString(ApexOptions.Symbol.OVERRIDE_APP_SCHEMA), this.getString(ApexOptions.Symbol.OVERRIDE_APP_ALIAS), this.getString(ApexOptions.Symbol.OVERRIDE_APP_ID), this.getString(ApexOptions.Symbol.OVERRIDE_APP_WORKSPACE)));
                }
                baos.reset();
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private void saveClobResult(OracleCallableStatement stmt) throws IOException, SQLException {
        Object[] l_result;
        for (Object l_tmp : l_result = (Object[])((Array)stmt.getObject(1)).getArray()) {
            Struct l_rec = (Struct)l_tmp;
            if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                this.write("  SQLTypeName: " + l_rec.getSQLTypeName());
                this.write("  Attr0: " + l_rec.getAttributes()[0].toString());
            }
            String l_name = (String)l_rec.getAttributes()[0];
            l_name = this.getExportFileLocation(l_name);
            Clob l_contents = (Clob)l_rec.getAttributes()[1];
            this._clobData.put(l_name, new RowDetails(l_name, l_contents.getSubString(1L, (int)l_contents.length()), ((Serializable)((Object)Objects.requireNonNullElse(this.getDec(ApexOptions.Symbol.APPLICATIONID), ""))).toString(), ((Serializable)((Object)Objects.requireNonNullElse(this.getDec(ApexOptions.Symbol.WORKSPACEID), ""))).toString(), this.getString(ApexOptions.Symbol.APPLICATIONNAME), this.getString(ApexOptions.Symbol.WORKSPACENAME), this.getString(ApexOptions.Symbol.OVERRIDE_APP_SCHEMA), this.getString(ApexOptions.Symbol.OVERRIDE_APP_ALIAS), this.getString(ApexOptions.Symbol.OVERRIDE_APP_ID), this.getString(ApexOptions.Symbol.OVERRIDE_APP_WORKSPACE)));
        }
    }

    private void executeAndWriteFiles(OracleCallableStatement stmt) throws SQLException, IOException {
        java.util.Date now;
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            this.write("  Start " + String.valueOf(now));
        }
        if (this.isBlobSupported()) {
            this.executeAndWriteBlobResult(stmt);
        } else {
            this.executeAndWriteClobResult(stmt);
        }
        if (this.getBool(ApexOptions.Symbol.DEBUG)) {
            now = new java.util.Date();
            this.write("  Completed at " + String.valueOf(now));
        }
    }

    private void deleteDirectoryIfNeeded() throws IOException {
        if (ApexOptions.isAPEXLangEnabled() && this.isAppExport() && this.isAPEXlangExport() && this.getBool(ApexOptions.Symbol.FORCE) && !this.isComponentExport()) {
            Path dirPath = ApexUtil.getPath(this._ctx, Paths.get(this.getExportFileLocation(""), new String[0]).toString(), false, true);
            FileUtils.deleteDirectory((File)new File(dirPath.toString()));
        }
    }

    private void executeAndWriteBlobResult(OracleCallableStatement stmt) throws SQLException, IOException {
        try (OracleCallableStatement oracleCallableStatement = stmt;){
            Optional<Path> outputFilePath;
            this.deleteDirectoryIfNeeded();
            stmt.execute();
            Blob result = stmt.getBlob(1);
            Path outputDir = Paths.get((String)this._ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]);
            if (null != this.getString(ApexOptions.Symbol.DIR) && !this.getString(ApexOptions.Symbol.DIR).isBlank()) {
                outputDir = outputDir.resolve(Paths.get(this.getString(ApexOptions.Symbol.DIR), new String[0]));
            }
            Optional<Path> optional = outputFilePath = ApexOptions.isAPEXLangEnabled() && this.isAPEXlangExport() && this.isAppExport() ? ApexUtil.unzip(outputDir, "application/", this.getExportFileParentDirectories(), result.getBinaryStream()) : ApexUtil.unzip(outputDir, result.getBinaryStream());
            if (outputFilePath.isPresent()) {
                this.write(ApexMessages.format("FILE_CREATED", Path.of(oracle.dbtools.common.utils.FileUtils.getCWD((ScriptRunnerContext)this._ctx), new String[0]).relativize(outputDir.resolve(outputFilePath.get())).toString()));
            } else {
                this.write(ApexMessages.getString("EXPORT_FILE_EMPTY"));
            }
        }
    }

    private void executeAndWriteClobResult(OracleCallableStatement stmt) throws IOException {
        String name = null;
        File exportFile = null;
        File applicationDotApexFile = null;
        try (OracleCallableStatement oracleCallableStatement = stmt;){
            this.deleteDirectoryIfNeeded();
            stmt.execute();
            Object[] result = (Object[])((Array)stmt.getObject(1)).getArray();
            boolean overWrite = this.getBool(ApexOptions.Symbol.OVERWRITE_FILES);
            for (Object tmp : result) {
                Struct rec = (Struct)tmp;
                if (this.getBool(ApexOptions.Symbol.DEBUG)) {
                    this.write("  SQLTypeName: " + rec.getSQLTypeName());
                    this.write("  Attr0: " + rec.getAttributes()[0].toString());
                }
                name = (String)rec.getAttributes()[0];
                name = this.getExportFileLocation(name);
                Clob contents = (Clob)rec.getAttributes()[1];
                exportFile = ApexUtil.getFile(this._ctx, name, true, overWrite || ApexOptions.isAPEXLangEnabled() && this.getBool(ApexOptions.Symbol.FORCE));
                if (ApexOptions.isAPEXLangEnabled() && this.getBool(ApexOptions.Symbol.FORCE) && this.isAPEXlangExport() && this.isComponentExport()) {
                    FileUtils.delete((File)exportFile);
                }
                ApexUtil.writeToFile(exportFile, contents.getCharacterStream(1L, (int)contents.length()));
                if (!this.isAPEXlangExport() || !this.isAppExport() || !APEXLangUtils.isApplicationFile(exportFile.getName())) continue;
                applicationDotApexFile = exportFile;
            }
            if (name != null) {
                name = name.replace("/.*\\.*$", "/" + (applicationDotApexFile != null ? applicationDotApexFile.getName() : exportFile.getName()));
            }
            this.write(ApexMessages.format("FILE_CREATED", name));
        }
        catch (Exception e) {
            this.write(ApexMessages.getString("NO_DATA_PLEASE_VERIFY"));
        }
    }

    public void exportFeedback() throws SQLException, IOException, OutputBufferNotInitialized {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_FEEDBACK.toString());
        }
        String sqlStmt = QueryUtils.getXMLQueries().getQuery("apex.export_feedback" + (this.isBlobSupported() ? BLOB_QUERIES_SUFFIX : ""), this._gConn).getSql();
        OracleCallableStatement l_stmt = this.getExportStmt(sqlStmt);
        boolean hasRows = false;
        if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID) && 0L != this.getDec(ApexOptions.Symbol.WORKSPACEID).longValue()) {
            String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspaceFeedback", this._gConn).getSql();
            PreparedStatement stmt = this._gConn.prepareStatement(sql);
            stmt.setBigDecimal(1, this.getDec(ApexOptions.Symbol.WORKSPACEID));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                hasRows = true;
                String wkspName = result.getString(1);
                this.write(ApexMessages.format("EXPORT_FEEDBACK_FOR_WS", this.getDec(ApexOptions.Symbol.WORKSPACEID).toPlainString(), wkspName));
                l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
                this.bind_yn(l_stmt, 3, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
                l_stmt.setDate(4, this.getDate(ApexOptions.Symbol.EXPFEEDBACKSINCE));
                l_stmt.setString(5, this.getString(ApexOptions.Symbol.DEPLOYMENTSYSTEM));
                this.handleWriteOrSave(l_stmt);
            }
            if (!hasRows) {
                this.write(ApexMessages.getString("NO_ENTRIES"));
            }
            result.close();
            stmt.close();
        } else {
            String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspacesFeedbacks", this._gConn).getSql();
            PreparedStatement stmt = this._gConn.prepareStatement(sql);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                hasRows = true;
                BigDecimal wkspID = result.getBigDecimal(1);
                String wkspName = result.getString(2);
                this.write(ApexMessages.format("EXPORT_FEEDBACK_FOR_WS", wkspID.toPlainString(), wkspName));
                l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
                this.bind_yn(l_stmt, 3, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
                l_stmt.setDate(4, this.getDate(ApexOptions.Symbol.EXPFEEDBACKSINCE));
                l_stmt.setString(5, this.getString(ApexOptions.Symbol.DEPLOYMENTSYSTEM));
                this.handleWriteOrSave(l_stmt);
            }
            if (!hasRows) {
                this.write(ApexMessages.getString("NO_ENTRIES"));
            }
            result.close();
            stmt.close();
        }
    }

    public void exportInstance() throws SQLException, IOException, InvalidApexExportException, OutputBufferNotInitialized, AppNotInstalledException, ApexQueryException {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_INSTANCE.toString());
        }
        String sql = QueryUtils.getXMLQueries().getQuery("gStmtInstance", this._gConn).getSql();
        PreparedStatement stmt = this._gConn.prepareStatement(sql);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            this._command.setOptionValue(ApexOptions.Symbol.WORKSPACEID, result.getBigDecimal(1));
            this._command.setOptionValue(ApexOptions.Symbol.APPLICATIONID, result.getBigDecimal(2));
            this._command.setOptionValue(ApexOptions.Symbol.WORKSPACENAME, result.getString(3));
            this._command.setOptionValue(ApexOptions.Symbol.APPLICATIONNAME, result.getString(4));
            this.exportApplication(true);
        }
    }

    public void exportStaticFiles() throws SQLException, IOException, InvalidApexExportException {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_STATIC_FILES.toString());
        }
        if (null == this.getDec(ApexOptions.Symbol.WORKSPACEID)) {
            throw new InvalidApexExportException(ApexMessages.getString("NO_WORKSPACE"));
        }
        String sqlStmt = QueryUtils.getXMLQueries().getQuery("apex.export_workspace_files" + (this.isBlobSupported() ? BLOB_QUERIES_SUFFIX : ""), this._gConn).getSql();
        OracleCallableStatement l_stmt = this.getExportStmt(sqlStmt);
        l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
        this.bind_yn(l_stmt, 3, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
        this.handleWriteOrSave(l_stmt);
    }

    public void exportWorkspace() throws SQLException, IOException {
        if (null == this.getString(ApexOptions.Symbol.EXPORT_TYPE) || "".equals(this.getString(ApexOptions.Symbol.EXPORT_TYPE))) {
            this._command.setOptionValue(ApexOptions.Symbol.EXPORT_TYPE, ApexOptions.Symbol.EXPORT_WORKSPACE.toString());
        }
        HashMap<String, String> binds = new HashMap<String, String>();
        DBUtil dbUtil = DBUtil.getInstance((Connection)this._gConn);
        binds.put("ID", this.getDec(ApexOptions.Symbol.WORKSPACEID).toString());
        String sql = QueryUtils.getXMLQueries().getQuery("gStmtWorkspace", this._gConn).getSql();
        String wName = dbUtil.executeOracleReturnOneCol(sql, binds);
        this.write(ApexMessages.format("EXPORT_WORKSPACE", this.getDec(ApexOptions.Symbol.WORKSPACEID).toPlainString(), wName));
        String sqlStmt = QueryUtils.getXMLQueries().getQuery("apex.export_workspace" + (this.isBlobSupported() ? BLOB_QUERIES_SUFFIX : ""), this._gConn).getSql();
        OracleCallableStatement l_stmt = this.getExportStmt(sqlStmt);
        l_stmt.setBigDecimal(2, this.getDec(ApexOptions.Symbol.WORKSPACEID));
        this.bind_yn(l_stmt, 3, this.getBool(ApexOptions.Symbol.EXPTEAMDEVDATA));
        this.bind_yn(l_stmt, 4, !this.getBool(ApexOptions.Symbol.EXPMINIMAL));
        this.bind_yn(l_stmt, 5, !this.getBool(ApexOptions.Symbol.SKIPEXPORTDATE));
        this.handleWriteOrSave(l_stmt);
    }

    private boolean isBlobSupported() {
        if (this.apexApiVersion == 0) {
            this.apexApiVersion = this.getApiVersion(this._gConn);
        }
        return this.apexApiVersion >= 4;
    }

    public Map<String, RowDetails> getResults() {
        return this._clobData;
    }

    public void list() throws SQLException, IOException {
        String report;
        HashMap<String, Object> binds = new HashMap<String, Object>();
        if (null == this.getDec(ApexOptions.Symbol.WORKSPACEID) && null == this.getDec(ApexOptions.Symbol.APPLICATIONID)) {
            report = "apex.list";
        } else if (null != this.getDec(ApexOptions.Symbol.WORKSPACEID) && null == this.getDec(ApexOptions.Symbol.APPLICATIONID)) {
            report = "gStmtListAppChanges";
            binds.put("b_workspace_id", this.getDec(ApexOptions.Symbol.WORKSPACEID));
        } else {
            report = "gStmtListCompChanges";
            binds.put("b_application_id", this.getDec(ApexOptions.Symbol.APPLICATIONID));
        }
        binds.put("b_updated_on", this.getDate(ApexOptions.Symbol.CHANGESSINCE));
        binds.put("b_updated_by", this.getString(ApexOptions.Symbol.CHANGESBY));
        ApexUtil.printList(this._gConn, this._ctx, report, binds);
    }

    public void setConnection(Connection conn) {
        this._gConn = conn;
    }

    public void setCtx(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public void setCWD(String cwd) {
    }

    public void setOutStream(OutputStream out) {
        this._out = out;
    }

    private Date getDate(Id id) {
        try {
            java.util.Date date = (java.util.Date)this._command.getOptionValue(id);
            return new Date(date.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class RowDetails {
        String fileName;
        String contents;
        String appId;
        String workId;
        String appName;
        String workName;
        String override_schema;
        String override_alias;
        String override_appid;
        String override_workspace;

        public RowDetails(String fName, String contents, String appId, String workId, String appName, String workName, String override_schema, String override_alias, String override_appid, String override_workspace) {
            this.fileName = fName;
            this.contents = contents;
            this.appId = appId;
            this.workId = workId;
            this.appName = appName;
            this.workName = workName;
            this.override_schema = override_schema;
            this.override_alias = override_alias;
            this.override_appid = override_appid;
            this.override_workspace = override_workspace;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getContents() {
            return this.contents;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        public String getWorkId() {
            return this.workId;
        }

        public String getWorkName() {
            return this.workName;
        }

        public String getOverrideSchema() {
            return this.override_schema;
        }

        public String getOverrideAlias() {
            return this.override_alias;
        }

        public String getOverrideAppId() {
            return this.override_appid;
        }

        public String getOverrideWorkspace() {
            return this.override_workspace;
        }

        public void setContent(String content) {
            this.contents = content;
        }
    }
}

