/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rest;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rest.ORDSExportPackage;
import oracle.dbtools.extension.rest.ORDSItemType;
import oracle.dbtools.extension.rest.RestExportCall;
import oracle.dbtools.extension.rest.RestOptions;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.jdbc.OracleConnection;

public class RestExportModuleCall
extends RestExportCall {
    ParsedCommand parsedCommand;
    Boolean runnable_as_admin = Boolean.FALSE;
    String schemaName = null;
    private static final String EXPORT_FUNCTION_NAME = "EXPORT_MODULE";

    public RestExportModuleCall(ParsedCommand parsedCommand) {
        super(ORDSItemType.MODULE, (String)parsedCommand.getParameterValue((Id)RestOptions.Symbol.ITEM_NAME));
        this.parsedCommand = parsedCommand;
        this.setCommandOptions(parsedCommand);
    }

    @Override
    public CallableStatement getCallableStatement(OracleConnection conn) throws SQLException {
        ORDSExportPackage ordsPackage;
        String plSqlCode = super.getPLSQL_CODE_BLOCK_CALL();
        plSqlCode = plSqlCode.replace(":PACKAGE_FUNCTION", EXPORT_FUNCTION_NAME);
        String moduleName = (String)this.parsedCommand.getParameterValue((Id)RestOptions.Symbol.ITEM_NAME);
        ORDSExportPackage oRDSExportPackage = ordsPackage = "".equals(this.schemaName) ? ORDSExportPackage.PUBLIC : ORDSExportPackage.ADMIN;
        if (!moduleName.isEmpty() && this.isPrefix((String)this.parsedCommand.getParameterValue((Id)RestOptions.Symbol.ITEM_NAME))) {
            moduleName = this.getModuleName((String)this.parsedCommand.getParameterValue((Id)RestOptions.Symbol.ITEM_NAME), conn, ordsPackage);
        }
        plSqlCode = plSqlCode.replace(":ORDS_PACKAGE", ordsPackage.getString());
        plSqlCode = plSqlCode.replace(":PARAMETERS", this.constructParameters(moduleName, ordsPackage));
        CallableStatement stmt = conn.prepareCall(plSqlCode);
        stmt.registerOutParameter(1, 2005);
        return stmt;
    }

    private String getModuleName(String modulePrefix, OracleConnection conn, ORDSExportPackage ordsPackage) throws SQLException {
        String MODULE_NAME_QUERY = ordsPackage.equals((Object)ORDSExportPackage.PUBLIC) ? "select NAME from USER_ORDS_MODULES WHERE URI_PREFIX = '" + modulePrefix + "'" : "select m.name from dba_ords_modules m left join dba_ords_Schemas s on m.schema_id = s.id where m.uri_prefix = '" + modulePrefix + "' and s.parsing_schema = '" + this.schemaName + "'";
        try (CallableStatement callableStatement = conn.prepareCall(MODULE_NAME_QUERY);){
            ResultSet rs = callableStatement.executeQuery();
            rs.next();
            String string = rs.getString("NAME");
            return string;
        }
    }

    private boolean isPrefix(String moduleNameOrPrefix) {
        if (moduleNameOrPrefix.equals("/")) {
            return true;
        }
        Pattern pattern = Pattern.compile("/.*/");
        Matcher matcher = pattern.matcher(moduleNameOrPrefix);
        return matcher.matches();
    }

    private void setCommandOptions(ParsedCommand parsedCommand) {
        this.schemaName = (String)parsedCommand.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME);
        this.runnable_as_admin = (Boolean)parsedCommand.getOptionValue((Id)RestOptions.Symbol.RUNNABLE_AS_ADMIN);
    }

    private String constructParameters(String moduleName, ORDSExportPackage ordsPackage) {
        String baseParameters = "p_module_name => '" + moduleName + "'";
        StringBuilder parameters = new StringBuilder(baseParameters);
        if (ordsPackage.equals((Object)ORDSExportPackage.ADMIN)) {
            parameters.append(", p_schema => '" + this.schemaName + "'");
            parameters.append(", p_runnable_as_admin => " + this.runnable_as_admin);
        }
        return parameters.toString();
    }
}

