/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rest;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.extension.rest.RestExportCall;
import oracle.dbtools.extension.rest.exceptions.OldOrdsVersionException;
import oracle.dbtools.extension.rest.exceptions.OrdsNotInstalledOrLackOfPrivilegesException;
import oracle.dbtools.extension.rest.exceptions.RestCallException;
import oracle.dbtools.extension.rest.exceptions.RestItemNotFoundException;
import oracle.dbtools.extension.rest.exceptions.UnknownRestCallException;
import oracle.jdbc.OracleConnection;

public class ORDSExportWrapper {
    public static String executeExport(RestExportCall call, OracleConnection conn) throws RestCallException {
        String string;
        block8: {
            CallableStatement callableStatement = call.getCallableStatement(conn);
            try {
                callableStatement.execute();
                string = callableStatement.getString(1);
                if (callableStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (callableStatement != null) {
                        try {
                            callableStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    ORDSExportWrapper.handleException(e, call);
                    return "";
                }
            }
            callableStatement.close();
        }
        return string;
    }

    private static String handleException(SQLException e, RestExportCall call) throws RestCallException {
        SQLException sqlException = e;
        int errorCode = sqlException.getErrorCode();
        if (e.getErrorCode() == 17289 || errorCode == 20854 || errorCode == 20012) {
            throw new RestItemNotFoundException(call.getOrdsItemType(), call.getOrdsItemName());
        }
        if (e.getErrorCode() == 6550) {
            if (e.getMessage().contains("PLS-00201")) {
                throw new OrdsNotInstalledOrLackOfPrivilegesException();
            }
            if (e.getMessage().contains("PLS-00302") || e.getMessage().contains("PLS-00306")) {
                throw new OldOrdsVersionException();
            }
        } else if (e.getErrorCode() == 942) {
            throw new OrdsNotInstalledOrLackOfPrivilegesException();
        }
        throw new UnknownRestCallException(e);
    }
}

