/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.core.utils;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.langdata.commands.ConfigMessages;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.LangDataException;
import oracle.dbtools.extension.langdata.core.exceptions.SQLQueryExecutionException;
import oracle.dbtools.extension.langdata.core.utils.LangDataQueryUtils;
import oracle.dbtools.extension.langdata.core.utils.LangUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ConfigUtils {
    public static HashMap<String, String> getLangdataConfig(Connection conn) throws SQLQueryExecutionException {
        LangUtils.updateConfigParams(conn);
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        HashMap<String, String> configParamsList = new HashMap<String, String>();
        for (String param : LangUtils.configParams) {
            HashMap<String, String> binds = new HashMap<String, String>();
            binds.put("param_name", param);
            String value = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.getconfigparam", conn).getSql(), binds);
            configParamsList.put(param, value);
        }
        return configParamsList;
    }

    public static List<Integer> longestValPerCol(List<List<String>> table) {
        if (table == null || table.isEmpty()) {
            return Collections.emptyList();
        }
        int columnCount = table.get(0).size();
        ArrayList<Integer> maxWidths = new ArrayList<Integer>(Collections.nCopies(columnCount, 0));
        for (List<String> row : table) {
            if (row == null || row.isEmpty()) continue;
            for (int j = 0; j < row.size(); ++j) {
                String col = row.get(j);
                if (col == null) {
                    col = "";
                }
                maxWidths.set(j, Math.max((Integer)maxWidths.get(j), col.length()));
            }
        }
        return maxWidths;
    }

    private static String[] splitCell(String cell, int width) {
        if (cell == null) {
            cell = "";
        }
        int numLines = (int)Math.ceil((double)cell.length() / (double)width);
        String[] lines = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            int start = i * width;
            int end = Math.min(start + width, cell.length());
            lines[i] = cell.substring(start, end);
        }
        return lines;
    }

    private static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    private static void printRow(List<String> row, List<Integer> maxWidths, int maxColumnWidth) {
        int maxLines = 1;
        ArrayList<String[]> splitRows = new ArrayList<String[]>();
        for (int i = 0; i < row.size(); ++i) {
            String col = row.get(i);
            String[] splitCol = ConfigUtils.splitCell(col, Math.min(maxWidths.get(i), maxColumnWidth));
            maxLines = Math.max(maxLines, splitCol.length);
            splitRows.add(splitCol);
        }
        for (int line = 0; line < maxLines; ++line) {
            ScriptRunnerContext context = LangDataConfig.getCurrentContext();
            for (int i = 0; i < row.size(); ++i) {
                String[] splitCol = (String[])splitRows.get(i);
                String cellLine = line < splitCol.length ? splitCol[line] : "";
                context.write(" | " + ConfigUtils.padRight(cellLine, Math.min(maxWidths.get(i), maxColumnWidth)));
            }
            context.writeln(" |");
        }
    }

    public static void printTable(List<List<String>> table) {
        if (table == null || table.isEmpty() || table.get(0) == null || table.get(0).isEmpty()) {
            return;
        }
        ScriptRunnerContext context = LangDataConfig.getCurrentContext();
        int terminalWidth = context.getSQLPlusConsoleReader().getWidth();
        int columns = table.get(0).size();
        int maxColumnWidth = (terminalWidth - (columns + 2) - columns * 2) / columns;
        List<Integer> maxWidths = ConfigUtils.longestValPerCol(table);
        int wholeWidth = maxWidths.stream().mapToInt(width -> Math.min(width, maxColumnWidth) + 3).sum();
        String headerSeparator = " +" + "=".repeat(wholeWidth - 1) + "+";
        String rowSeparator = " +" + "-".repeat(wholeWidth - 1) + "+";
        context.writeln(headerSeparator);
        for (int rowIndex = 0; rowIndex < table.size(); ++rowIndex) {
            List<String> row = table.get(rowIndex);
            ConfigUtils.printRow(row, maxWidths, maxColumnWidth);
            if (rowIndex == 0) {
                context.writeln(headerSeparator);
                continue;
            }
            context.writeln(rowSeparator);
        }
    }

    public static void printConfigTable(HashMap<String, String> configParams) {
        ArrayList<String> header = new ArrayList<String>();
        header.add("SETTING NAME");
        header.add("VALUE");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(header);
        configParams.forEach((k, v) -> {
            ArrayList<String> row = new ArrayList<String>();
            row.add((String)k);
            if (v == null) {
                row.add("");
            } else {
                row.add((String)v);
            }
            table.add(row);
        });
        ConfigUtils.printTable(table);
    }

    public static String getConfigListJson(HashMap<String, String> configParamsList) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, String> entry : configParamsList.entrySet()) {
            builder.add(entry.getKey(), entry.getValue() != null ? entry.getValue() : "");
        }
        JsonObject jsonObject = builder.build();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
        StringWriter stringWriter = new StringWriter();
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        JsonWriter jsonWriter = writerFactory.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        return stringWriter.toString();
    }

    public static void printConfigListJson(HashMap<String, String> configParamsList) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\n");
        int count = 0;
        for (Map.Entry<String, String> entry : configParamsList.entrySet()) {
            jsonBuilder.append("  ").append("\"").append(entry.getKey().replace("\"", "\\\"")).append("\": \"").append(entry.getValue() != null ? entry.getValue().replace("\"", "\\\"") : "").append("\"");
            if (++count < configParamsList.size()) {
                jsonBuilder.append(",\n");
                continue;
            }
            jsonBuilder.append("\n");
        }
        jsonBuilder.append("}");
        String jsonString = jsonBuilder.toString();
        LangDataConfig.getCurrentContext().writeln(jsonString);
    }

    public static void writeJsonToFile(String directory, String jsonList) throws IOException {
        File dir = new File(directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + directory);
        }
        File jsonFile = new File(dir, "langdata_config.json");
        try (FileWriter writer = new FileWriter(jsonFile);){
            writer.write(jsonList);
        }
    }

    public static void importConfigFromJsonFile(String filePath, Connection conn) throws LangDataException {
        if (filePath == null || !filePath.toLowerCase().endsWith(".json")) {
            throw new LangDataException(ConfigMessages.getString("JSON_FILE_REQUIRED"));
        }
        File jsonFile = new File(filePath);
        if (!jsonFile.exists() || !jsonFile.isFile()) {
            throw new LangDataException(ConfigMessages.format("INVALID_JSON_FILE_INPUT", filePath));
        }
        try (FileInputStream fis = new FileInputStream(jsonFile);
             JsonReader reader = Json.createReader((InputStream)fis);){
            JsonObject jsonObject;
            try {
                jsonObject = reader.readObject();
            }
            catch (Exception e) {
                throw new LangDataException(ConfigMessages.format("INVALID_JSON_FORMAT", filePath));
            }
            for (Map.Entry entry : jsonObject.entrySet()) {
                String name = (String)entry.getKey();
                String value = jsonObject.getString(name, null);
                if (value == null) {
                    throw new LangDataException(ConfigMessages.format("NULL_CONFIG_NAME", name));
                }
                DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
                HashMap<String, String> binds = new HashMap<String, String>();
                binds.put("config_name", name);
                binds.put("config_value", value);
                try {
                    dbUtil.execute(LangDataQueryUtils.getXMLQueries().getQuery("langdata.updateconfig", conn).getSql(), binds);
                    if (!LangDataConfig.isVerbose() && !LangDataConfig.isDebug()) continue;
                    LangDataConfig.getCurrentContext().writeln(ConfigMessages.format("IMPORT_NAME_VALUE_VERBOSE", name, value));
                }
                catch (Exception e) {
                    if (LangDataConfig.isDebug()) {
                        LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
                        continue;
                    }
                    LangDataConfig.getCurrentContext().writeln(ConfigMessages.format("UPDATE_ERROR", name) + e.getLocalizedMessage());
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new LangDataException("JSON file not found: " + filePath);
        }
        catch (IOException e) {
            throw new LangDataException("Error reading JSON file: " + e.getMessage());
        }
    }
}

