/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.init;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.langdata.commands.InitMessages;
import oracle.dbtools.extension.langdata.core.exceptions.AppExpertUserInvalid;
import oracle.dbtools.extension.langdata.core.exceptions.IncompatibleDatabaseVersion;
import oracle.dbtools.extension.langdata.core.exceptions.InvalidMountDirectory;
import oracle.dbtools.extension.langdata.core.exceptions.OMFNotConfigured;
import oracle.dbtools.extension.langdata.core.exceptions.OracleHomeNotFound;
import oracle.dbtools.extension.langdata.core.exceptions.OracleHomeNotReal;
import oracle.dbtools.extension.langdata.core.exceptions.SYSDBAPrivilegesRequired;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.InitUtils;
import oracle.dbtools.extension.langdata.core.utils.LangUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class InitPreCheck {
    private final ScriptRunnerContext ctx;
    private final Connection conn;
    private final Boolean isAutonomousDB;
    private final String pdbName;
    private final Path installTempDir;
    private final String mountDir;
    private final SqlClCommandsRunner sqlClCommandsRunner;
    private static int preCheckStepCount = 0;
    private static int totalSteps = 0;

    public InitPreCheck(Connection conn, ScriptRunnerContext ctx, Boolean isAutonomousDB, String pdbName, String mountDir, SqlClCommandsRunner sqlClCommandsRunner) {
        this.conn = conn;
        this.ctx = ctx;
        this.isAutonomousDB = isAutonomousDB;
        this.pdbName = pdbName;
        this.mountDir = mountDir;
        this.installTempDir = Paths.get(LangUtils.getTempDir(), "langdata" + File.separator + "install");
        this.sqlClCommandsRunner = sqlClCommandsRunner;
        totalSteps = isAutonomousDB != false ? 2 : 5;
        preCheckStepCount = 0;
    }

    public void runAllPreChecks() throws OracleHomeNotReal, OracleHomeNotFound, IncompatibleDatabaseVersion, SQLException, SYSDBAPrivilegesRequired, InvalidMountDirectory, OMFNotConfigured, AppExpertUserInvalid {
        if (!this.isAutonomousDB.booleanValue()) {
            this.handleOracleHomeValidation();
        }
        this.preCheckDatabaseVersion();
        this.preCheckSysdbaPrivileges();
        if (!this.isAutonomousDB.booleanValue()) {
            this.preCheckMountDirPrivileges();
            this.preCheckOMF();
        }
    }

    private String getStep() {
        return "[" + ++preCheckStepCount + "/" + totalSteps + "]";
    }

    private void handleOracleHomeValidation() throws OracleHomeNotReal, OracleHomeNotFound {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        String validationMsg = InitMessages.getString("PRE_CHECK_OH_VALIDATED");
        if (!this.isAutonomousDB.booleanValue() && !InitUtils.isOHReal(this.ctx)) {
            GeneralMessages.printErrorStatus(step, validationMsg, InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.getString("ORACLE_HOME_NOT_REAL_EXCEPTION"));
            throw new OracleHomeNotReal(InitMessages.getString("ORACLE_HOME_NOT_REAL_EXCEPTION"));
        }
        long endTime = System.currentTimeMillis();
        GeneralMessages.printSuccessStatus(step, validationMsg, InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
    }

    private void preCheckDatabaseVersion() throws IncompatibleDatabaseVersion, SQLException {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        int dbMajorVersion = this.conn.getMetaData().getDatabaseMajorVersion();
        if (dbMajorVersion < 23) {
            long endTime = System.currentTimeMillis();
            GeneralMessages.printErrorStatus(step, InitMessages.getString("PRE_CHECK_DB_VERSION"), InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.format("DATABASE_INCOMPATIBLE_EXCEPTION", dbMajorVersion));
            throw new IncompatibleDatabaseVersion(InitMessages.format("DATABASE_INCOMPATIBLE_EXCEPTION", dbMajorVersion));
        }
        long endTime = System.currentTimeMillis();
        GeneralMessages.printSuccessStatus(step, InitMessages.getString("PRE_CHECK_DB_VERSION"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
    }

    private void preCheckSysdbaPrivileges() throws SYSDBAPrivilegesRequired {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        if (!this.isAutonomousDB.booleanValue() && !InitUtils.isSYSDBA(this.conn).booleanValue()) {
            long endTime = System.currentTimeMillis();
            GeneralMessages.printErrorStatus(step, InitMessages.getString("PRE_CHECK_DBA"), InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.getString("SYSDBA_PRIVILEGES_REQUIRED"));
            throw new SYSDBAPrivilegesRequired(InitMessages.getString("SYSDBA_PRIVILEGES_REQUIRED"));
        }
        if (this.isAutonomousDB.booleanValue() && !InitUtils.isADMIN(this.conn).booleanValue()) {
            long endTime = System.currentTimeMillis();
            GeneralMessages.printErrorStatus(step, InitMessages.getString("PRE_CHECK_ADMIN"), InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.getString("ADMIN_PRIVILEGES_REQUIRED"));
            throw new SYSDBAPrivilegesRequired(InitMessages.getString("ADMIN_PRIVILEGES_REQUIRED"));
        }
        long endTime = System.currentTimeMillis();
        GeneralMessages.printSuccessStatus(step, InitMessages.getString(this.isAutonomousDB != false ? "PRE_CHECK_ADMIN" : "PRE_CHECK_DBA"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
    }

    private void preCheckMountDirPrivileges() throws InvalidMountDirectory {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        String mountDirStr = LangUtils.getMountDir(this.mountDir);
        Path mount_dir = Paths.get(mountDirStr, new String[0]);
        if (!Files.exists(mount_dir, new LinkOption[0]) || !Files.isDirectory(mount_dir, new LinkOption[0])) {
            GeneralMessages.printErrorStatus(step, InitMessages.getString("PRE_CHECK_MOUNT_DIR"), InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.getString("DIRECTORY_NOT_REAL"));
            throw new InvalidMountDirectory(InitMessages.getString("DIRECTORY_NOT_REAL"));
        }
        if (!Files.isReadable(mount_dir) || !Files.isWritable(mount_dir)) {
            GeneralMessages.printErrorStatus(step, InitMessages.getString("PRE_CHECK_MOUNT_DIR"), InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.getString("INVALID_MOUNT_DIR"));
            throw new InvalidMountDirectory(InitMessages.getString("INVALID_MOUNT_DIR"));
        }
        long endTime = System.currentTimeMillis();
        GeneralMessages.printSuccessStatus(step, InitMessages.getString("PRE_CHECK_MOUNT_DIR"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
    }

    private void preCheckOMF() throws OMFNotConfigured {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        if (!this.isAutonomousDB.booleanValue() && !InitUtils.checkOMF(this.conn).booleanValue()) {
            long endTime = System.currentTimeMillis();
            GeneralMessages.printErrorStatus(step, InitMessages.getString("PRE_CHECK_OMF"), InitMessages.getString("STEP_FAILED"));
            GeneralMessages.errorMessage("\n" + InitMessages.getString("OMF_NOT_CONFIGURED"));
            this.ctx.writeln(InitMessages.getString("STEPS_TO_CONFIGURE_OMF"));
            throw new OMFNotConfigured(InitMessages.getString("OMF_NOT_CONFIGURED"));
        }
        long endTime = System.currentTimeMillis();
        GeneralMessages.printSuccessStatus(step, InitMessages.getString("PRE_CHECK_OMF"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
    }
}

