/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text;

import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TextReportSection {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReportSection.class.getName());
    public static final String SECTION_INDENT = "  ";
    private TextReportSectionName sectionName;
    private Integer maxRelevantDataRows;
    private String indent;
    private final Map<String, TextReportField> fieldList = new TreeMap<String, TextReportField>();
    private int widestLabelWidth;

    public void printSection(TextReportContext reportContext) {
        reportContext.getPrintWriter().print(this.sectionName.getSectionHeader(reportContext));
        for (Map.Entry<String, TextReportField> entry : this.fieldList.entrySet()) {
            TextReportField textReportField = entry.getValue();
            textReportField.printText(this);
        }
    }

    public Set<String> getFieldListKeySet() {
        return this.fieldList.keySet();
    }

    public TextReportField getField(String key) {
        return this.fieldList.get(key);
    }

    void addField(TextReportField textReportField) {
        TextReportLabeledValue labeledValue;
        String labelKey = textReportField.getLabelKey();
        if (this.fieldList.get(labelKey) != null) {
            log.warning("Label Key used more than once: " + labelKey);
        }
        this.fieldList.put(labelKey, textReportField);
        if (textReportField instanceof TextReportLabeledValue && (labeledValue = (TextReportLabeledValue)textReportField).getLabelWidth() > this.widestLabelWidth) {
            this.widestLabelWidth = labeledValue.getLabelWidth();
        }
    }

    private static Integer $default$maxRelevantDataRows() {
        return Integer.MAX_VALUE;
    }

    private static String $default$indent() {
        return SECTION_INDENT;
    }

    private static int $default$widestLabelWidth() {
        return 0;
    }

    TextReportSection(TextReportSectionName sectionName, Integer maxRelevantDataRows, String indent, int widestLabelWidth) {
        this.sectionName = sectionName;
        this.maxRelevantDataRows = maxRelevantDataRows;
        this.indent = indent;
        this.widestLabelWidth = widestLabelWidth;
    }

    public static TextReportSectionBuilder builder() {
        return new TextReportSectionBuilder();
    }

    public TextReportSectionName getSectionName() {
        return this.sectionName;
    }

    public Integer getMaxRelevantDataRows() {
        return this.maxRelevantDataRows;
    }

    public String getIndent() {
        return this.indent;
    }

    public int getWidestLabelWidth() {
        return this.widestLabelWidth;
    }

    public void setSectionName(TextReportSectionName sectionName) {
        this.sectionName = sectionName;
    }

    public void setMaxRelevantDataRows(Integer maxRelevantDataRows) {
        this.maxRelevantDataRows = maxRelevantDataRows;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setWidestLabelWidth(int widestLabelWidth) {
        this.widestLabelWidth = widestLabelWidth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportSection)) {
            return false;
        }
        TextReportSection other = (TextReportSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidestLabelWidth() != other.getWidestLabelWidth()) {
            return false;
        }
        Integer this$maxRelevantDataRows = this.getMaxRelevantDataRows();
        Integer other$maxRelevantDataRows = other.getMaxRelevantDataRows();
        if (this$maxRelevantDataRows == null ? other$maxRelevantDataRows != null : !((Object)this$maxRelevantDataRows).equals(other$maxRelevantDataRows)) {
            return false;
        }
        TextReportSectionName this$sectionName = this.getSectionName();
        TextReportSectionName other$sectionName = other.getSectionName();
        if (this$sectionName == null ? other$sectionName != null : !((Object)((Object)this$sectionName)).equals((Object)other$sectionName)) {
            return false;
        }
        String this$indent = this.getIndent();
        String other$indent = other.getIndent();
        if (this$indent == null ? other$indent != null : !this$indent.equals(other$indent)) {
            return false;
        }
        Map<String, TextReportField> this$fieldList = this.fieldList;
        Map<String, TextReportField> other$fieldList = other.fieldList;
        return !(this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportSection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidestLabelWidth();
        Integer $maxRelevantDataRows = this.getMaxRelevantDataRows();
        result = result * 59 + ($maxRelevantDataRows == null ? 43 : ((Object)$maxRelevantDataRows).hashCode());
        TextReportSectionName $sectionName = this.getSectionName();
        result = result * 59 + ($sectionName == null ? 43 : ((Object)((Object)$sectionName)).hashCode());
        String $indent = this.getIndent();
        result = result * 59 + ($indent == null ? 43 : $indent.hashCode());
        Map<String, TextReportField> $fieldList = this.fieldList;
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        return result;
    }

    public String toString() {
        return "TextReportSection(sectionName=" + (Object)((Object)this.getSectionName()) + ", maxRelevantDataRows=" + this.getMaxRelevantDataRows() + ", indent=" + this.getIndent() + ", fieldList=" + this.fieldList + ", widestLabelWidth=" + this.getWidestLabelWidth() + ")";
    }

    public static class TextReportSectionBuilder {
        private TextReportSectionName sectionName;
        private boolean maxRelevantDataRows$set;
        private Integer maxRelevantDataRows$value;
        private boolean indent$set;
        private String indent$value;
        private boolean widestLabelWidth$set;
        private int widestLabelWidth$value;

        TextReportSectionBuilder() {
        }

        public TextReportSectionBuilder sectionName(TextReportSectionName sectionName) {
            this.sectionName = sectionName;
            return this;
        }

        public TextReportSectionBuilder maxRelevantDataRows(Integer maxRelevantDataRows) {
            this.maxRelevantDataRows$value = maxRelevantDataRows;
            this.maxRelevantDataRows$set = true;
            return this;
        }

        public TextReportSectionBuilder indent(String indent) {
            this.indent$value = indent;
            this.indent$set = true;
            return this;
        }

        public TextReportSectionBuilder widestLabelWidth(int widestLabelWidth) {
            this.widestLabelWidth$value = widestLabelWidth;
            this.widestLabelWidth$set = true;
            return this;
        }

        public TextReportSection build() {
            Integer maxRelevantDataRows$value = this.maxRelevantDataRows$value;
            if (!this.maxRelevantDataRows$set) {
                maxRelevantDataRows$value = TextReportSection.$default$maxRelevantDataRows();
            }
            String indent$value = this.indent$value;
            if (!this.indent$set) {
                indent$value = TextReportSection.$default$indent();
            }
            int widestLabelWidth$value = this.widestLabelWidth$value;
            if (!this.widestLabelWidth$set) {
                widestLabelWidth$value = TextReportSection.$default$widestLabelWidth();
            }
            return new TextReportSection(this.sectionName, maxRelevantDataRows$value, indent$value, widestLabelWidth$value);
        }

        public String toString() {
            return "TextReportSection.TextReportSectionBuilder(sectionName=" + (Object)((Object)this.sectionName) + ", maxRelevantDataRows$value=" + this.maxRelevantDataRows$value + ", indent$value=" + this.indent$value + ", widestLabelWidth$value=" + this.widestLabelWidth$value + ")";
        }
    }
}

