/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.filters;

import com.oracle.premigration.helpers.Utilities;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.NonNull;

public final class Filter {
    private static final char COMPONENT_DELIMITER = ',';
    private static final char NAME_VALUE_DELIMITER = ':';
    private static final String REGEX_IGNORE_DELIM_IF_QUOTED = "(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private final Pattern objectOwner;
    private final Pattern objectName;
    private final String objectType;

    public static Filter fromPropertyValue(String propertyValue) {
        String[] components = propertyValue.trim().split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", 4);
        if (components.length != 3) {
            throw new IllegalArgumentException("Improperly formatted report filter property");
        }
        String schemaName = "";
        String objectName = "";
        String databaseType = "";
        block5: for (String s : components) {
            String component = s.trim();
            String[] nameValuePair = component.split(":(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", 3);
            if (nameValuePair.length != 2) {
                throw new IllegalArgumentException("Improperly formatted report filter property");
            }
            nameValuePair[0] = nameValuePair[0].trim();
            nameValuePair[1] = nameValuePair[1].trim();
            nameValuePair[1] = nameValuePair[1].replaceAll("(^\")|(\"$)", "");
            switch (FilterComponent.valueOf(nameValuePair[0])) {
                case objectOwner: {
                    schemaName = nameValuePair[1];
                    continue block5;
                }
                case objectName: {
                    objectName = nameValuePair[1];
                    continue block5;
                }
                case objectType: {
                    databaseType = nameValuePair[1];
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected FilterComponent: " + nameValuePair[0]);
                }
            }
        }
        return Filter.fromStrings(schemaName, objectName, databaseType);
    }

    public static Filter fromStrings(@NonNull String schemaName, @NonNull String objectName, @NonNull String databaseType) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (objectName == null) {
            throw new NullPointerException("objectName is marked non-null but is null");
        }
        if (databaseType == null) {
            throw new NullPointerException("databaseType is marked non-null but is null");
        }
        return Filter.builder().objectOwner(Pattern.compile(schemaName)).objectName(Pattern.compile(objectName)).objectType(databaseType).build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Filter)) {
            return false;
        }
        Filter otherFilter = (Filter)other;
        return this.objectOwner.pattern().equals(otherFilter.objectOwner.pattern()) && this.objectName.pattern().equals(otherFilter.objectName.pattern()) && this.objectType.equals(otherFilter.objectType);
    }

    public int hashCode() {
        return Objects.hash(this.objectOwner, this.objectName, this.objectType);
    }

    public String toString() {
        ArrayList<String> filterComponents = new ArrayList<String>();
        filterComponents.add(Filter.stringifyNameValue(FilterComponent.objectOwner.name(), this.objectOwner.pattern()));
        filterComponents.add(Filter.stringifyNameValue(FilterComponent.objectName.name(), this.objectName.pattern()));
        filterComponents.add(Filter.stringifyNameValue(FilterComponent.objectType.name(), this.objectType));
        return Utilities.join(String.valueOf(','), filterComponents);
    }

    private static String stringifyNameValue(String name, String value) {
        String neededQuotes = value.contains(String.valueOf(':')) ? "\"" : "";
        return name + ':' + neededQuotes + value + neededQuotes;
    }

    Filter(Pattern objectOwner, Pattern objectName, String objectType) {
        this.objectOwner = objectOwner;
        this.objectName = objectName;
        this.objectType = objectType;
    }

    public static FilterBuilder builder() {
        return new FilterBuilder();
    }

    public Pattern getObjectOwner() {
        return this.objectOwner;
    }

    public Pattern getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public static enum FilterComponent {
        objectOwner,
        objectName,
        objectType;

    }

    public static class FilterBuilder {
        private Pattern objectOwner;
        private Pattern objectName;
        private String objectType;

        FilterBuilder() {
        }

        public FilterBuilder objectOwner(Pattern objectOwner) {
            this.objectOwner = objectOwner;
            return this;
        }

        public FilterBuilder objectName(Pattern objectName) {
            this.objectName = objectName;
            return this;
        }

        public FilterBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public Filter build() {
            return new Filter(this.objectOwner, this.objectName, this.objectType);
        }

        public String toString() {
            return "Filter.FilterBuilder(objectOwner=" + this.objectOwner + ", objectName=" + this.objectName + ", objectType=" + this.objectType + ")";
        }
    }
}

