/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.pojos;

import com.oracle.premigration.cli.configuration.NameSpace;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.helpers.Job;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStoreManager;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorePasswordInfo;
import com.oracle.premigration.loadpwd.security.keystorage.PasswordConsole;
import com.oracle.premigration.loadpwd.security.pojos.KeystoreEntryAdder;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import oracle.security.pki.OracleSecretStoreException;
import org.apache.commons.cli.ParseException;

public class KeystoreEntryAdderUser
extends KeystoreEntryAdder {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(KeystoreEntryAdderUser.class.getName());

    public KeystoreEntryAdderUser(KeyStorePasswordInfo passInfo, List<Job> jobList, KeyStoreManager keyStoreManager, EnvironmentContext envCtx) {
        super(passInfo, jobList, keyStoreManager, envCtx);
    }

    @Override
    public void addEntry() throws PremigrationException {
        log.info("Name space: " + this.passInfo.getNameSpace());
        log.info("User " + this.passInfo.getUser());
        Job config = KeystoreEntryAdderUser.verifyNameSpace(this.jobList, this.passInfo.getNameSpace());
        if (config == null) {
            Utilities.printAndLogErrorMessage(lang.txt("PWDP_INVALID_NAMESPACE", this.passInfo.getNameSpace()), this.envCtx, Level.INFO);
            return;
        }
        String user = this.verifyUser();
        this.keyStoreManager.addAlias(this.passInfo.getAlias());
        try {
            if (this.passInfo.isNoCheck()) {
                PasswordConsole.listPasswordInfo(this.envCtx);
                return;
            }
            char[] password = this.keyStoreManager.getOracleWallet().getSecretStore().getSecret(this.passInfo.getAlias());
            if (KeystoreEntryAdderUser.verifyPassword(config.getNameSpace(), this.passInfo.getUser(), password)) {
                Utilities.printAndLogErrorMessage(lang.txt("PWDP_INVALID_CREDENTIAL", user), this.envCtx, Level.INFO);
                this.keyStoreManager.deleteAlias(this.passInfo.getAlias());
            }
        }
        catch (IOException | SQLException | OracleSecretStoreException | ParseException e) {
            Utilities.printAndLogErrorMessage(lang.txt("PWDP_INVALID_CREDENTIAL", user), this.envCtx, Level.INFO);
            return;
        }
        PasswordConsole.listPasswordInfo(this.envCtx);
    }

    private static Job verifyNameSpace(List<Job> configList, String nameSpace) {
        for (Job config : configList) {
            if (!config.getNameSpace().getName().equalsIgnoreCase(nameSpace)) continue;
            return config;
        }
        return null;
    }

    public static boolean verifyPassword(NameSpace name, String user, char[] password) throws ParseException, SQLException {
        String connectionString = name.getArgumentValue("--connectstring");
        try {
            Connection connection = DriverManager.getConnection(connectionString, user, String.valueOf(password));
            return connection == null;
        }
        catch (SQLException e) {
            return true;
        }
    }
}

