/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class has_users_lack_create_privileges
extends Check
implements Fixable {
    public has_users_lack_create_privileges() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.NONE, LockdownProfile.DWCS_ADWS, LockdownProfile.OLTP_ATPS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "u.owner");
        ArrayList<String> conditions = new ArrayList<String>();
        for (QueryObjects ot : QueryObjects.values()) {
            String condition = "(u.object_type = " + ot.getType() + " AND NOT EXISTS (    SELECT 1 FROM dba_sys_privs     WHERE grantee = owner     AND privilege IN (" + String.join((CharSequence)", ", ot.getPrivilege()) + ")))";
            conditions.add(condition);
        }
        String completedQuery = String.join((CharSequence)" OR ", conditions);
        String sqlQuery = "SELECT u.owner, u.object_name, u.object_type FROM dba_objects u " + whereClause + " AND u.owner <> 'PUBLIC'  AND ((u.object_type = 'TABLE' AND NOT EXISTS (     SELECT 1 FROM dba_sys_privs      WHERE grantee = owner      AND privilege IN ('CREATE TABLE', 'CREATE ANY TABLE') ))  OR " + completedQuery + ")";
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupNameRevoke = "revoke_create_privileges";
        String fixupNameGrant = "grant_create_privileges";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPathGrant = locus.getPathContribution() + File.separator + "grant_create_privileges" + ".sql";
        String relPathRevoke = locus.getPathContribution() + File.separator + "revoke_create_privileges" + ".sql";
        Fixup sqlFixupGrant = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("grant_create_privileges").parentPath(parentFolderPath).relativeFilePath(relPathGrant).build();
        Fixup sqlFixupRevoke = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("revoke_create_privileges").parentPath(parentFolderPath).relativeFilePath(relPathRevoke).build();
        try (FixupFileHelper fixupFileHelperRevoke = new FixupFileHelper(this, sqlFixupRevoke);
             FixupFileHelper fixupFileHelperGrant = new FixupFileHelper(this, sqlFixupGrant);){
            ArrayList<String> dclStatementRevoke = new ArrayList<String>();
            ArrayList<String> dclStatementGrant = new ArrayList<String>();
            sqlFixupGrant.getNotes().add(this.lang.txt("CHECK.HAS_USERS_LACK_CREATE_PRIVILEGES.FIXUP_BEFORE_IMPORT_OBJECTS"));
            sqlFixupRevoke.getNotes().add(this.lang.txt("CHECK.HAS_USERS_LACK_CREATE_PRIVILEGES.FIXUP_AFTER_IMPORT_OBJECTS"));
            fixupFileHelperRevoke.writeNotes();
            fixupFileHelperGrant.writeNotes();
            ArrayList<String> ownerList = new ArrayList<String>();
            for (Map<String, String> map : this.getRelevantObjectsData()) {
                if (ownerList.contains(map.get("OWNER"))) continue;
                ownerList.add(map.get("OWNER"));
            }
            for (String string : ownerList) {
                dclStatementGrant.add("GRANT ALL PRIVILEGES TO " + string + ";");
            }
            for (String string : ownerList) {
                dclStatementRevoke.add("REVOKE ALL PRIVILEGES FROM " + string + ";");
            }
            fixupFileHelperGrant.writeFixupText(dclStatementGrant, 1);
            fixupFileHelperRevoke.writeFixupText(dclStatementRevoke, 1);
            this.addFixup(sqlFixupGrant);
            this.addFixup(sqlFixupRevoke);
        }
        catch (Exception e) {
            String errorMsg = Utilities.getErrorText("ERROR3005", e, "revoke_create_privileges", this.getName());
            Utilities.printAndLogErrorMessage(errorMsg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMsg, e);
        }
    }

    public static enum QueryObjects {
        CLUSTER("'CLUSTER'", Arrays.asList("'CREATE CLUSTER'", "'CREATE ANY CLUSTER'")),
        FUNCTION("'FUNCTION'", Arrays.asList("'CREATE PROCEDURE'", "'CREATE ANY PROCEDURE'")),
        INDEX("'INDEX'", Collections.singletonList("'CREATE ANY INDEX'")),
        JOB("'JOB'", Arrays.asList("'CREATE ANY JOB'", "'CREATE JOB'")),
        LIBRARY("'LIBRARY'", Arrays.asList("'CREATE ANY LIBRARY'", "'CREATE LIBRARY'")),
        OPERATOR("'OPERATOR'", Arrays.asList("'CREATE OPERATOR'", "'CREATE ANY OPERATOR'")),
        PACKAGE("'PACKAGE BODY'", Arrays.asList("'CREATE PROCEDURE'", "'CREATE ANY PROCEDURE'")),
        PROCEDURE("'PROCEDURE'", Arrays.asList("'CREATE PROCEDURE'", "'CREATE ANY PROCEDURE'")),
        SEQUENCE("'SEQUENCE'", Arrays.asList("'CREATE ANY SEQUENCE'", "'CREATE SEQUENCE'")),
        SYNONYM("'SYNONYM'", Arrays.asList("'CREATE SYNONYM'", "'CREATE ANY SYNONYM'")),
        TRIGGER("'TRIGGER'", Arrays.asList("'CREATE TRIGGER'", "'CREATE ANY TRIGGER'")),
        TYPE("'TYPE'", Arrays.asList("'CREATE ANY TYPE'", "'CREATE TYPE'")),
        VIEW("'VIEW'", Arrays.asList("'CREATE ANY VIEW'", "'CREATE VIEW'"));

        final String type;
        final List<String> privilege;

        private QueryObjects(String type, List<String> privilege) {
            this.type = type;
            this.privilege = privilege;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getPrivilege() {
            return this.privilege;
        }
    }
}

