/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;

public abstract class has_logging_off
extends FilterableCheck {
    protected has_logging_off() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.OTHER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String dbForceLogging = SqlUtils.getDatabaseForceLogging(exeCtx);
        if ("YES".equalsIgnoreCase(dbForceLogging)) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_DATABASE_SETTING", this.getName(), "V$DATABASE", "FORCE_LOGGING", "YES"), CheckResult.PASS);
        }
    }
}

