/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_fmw_registry_in_system
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_fmw_registry_in_system.class.getName());

    public has_fmw_registry_in_system() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeColumn("OBJECT_TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT OWNER, OBJECT_NAME, OBJECT_TYPE FROM SYS.DBA_OBJECTS WHERE OWNER='SYSTEM' AND (OBJECT_NAME='SCHEMA_VERSION_REGISTRY' OR OBJECT_NAME='SCHEMA_VERSION_REGISTRY$')");
    }
}

