/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class has_common_objects
extends Check
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_common_objects.class.getName());
    private boolean hasCommonColumn;

    public has_common_objects() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.hasCommonColumn = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_USERS").column("COMMON").build());
        if (this.hasCommonColumn) {
            String exclusionForOGGUser = exeCtx.isUsingOGG() ? " AND USERNAME <> 'C##GGADMIN' " : "";
            this.setSqlQuery("SELECT USERNAME AS OBJECT_NAME, 'USER' AS OBJECT_TYPE FROM SYS.DBA_USERS WHERE (COMMON='YES' OR UPPER(USERNAME) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y' " + exclusionForOGGUser + " UNION ALL  SELECT ROLE AS OBJECT_NAME, 'ROLE' AS OBJECT_TYPE FROM SYS.DBA_ROLES R WHERE (COMMON='YES' OR UPPER(ROLE) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y'  UNION ALL  SELECT UNIQUE PROFILE AS OBJECT_NAME, 'PROFILE' AS OBJECT_TYPE FROM SYS.DBA_PROFILES WHERE COMMON='YES' OR UPPER(PROFILE) LIKE 'C##%' AND UPPER(PROFILE) NOT IN ('ORA_ADMIN_PROFILE','ORA_APP_PROFILE','ORA_MANDATORY_PROFILE')");
        } else {
            String skipReason = this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "COMMON", "COLUMN");
            this.skipCheck(skipReason, CheckResult.PASS);
        }
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "create_common_objects";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPath = locus.getPathContribution() + File.separator + "create_common_objects" + ".sql";
        Fixup sqlFixup = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).runAtCDBLevel(!exeCtx.isAutonomousTarget()).fixupName("create_common_objects").parentPath(parentFolderPath).relativeFilePath(relPath).build();
        try (FixupFileHelper fileHelper = new FixupFileHelper(this, sqlFixup);){
            if (this.hasCommonColumn) {
                boolean isTablespaceMapping;
                String commonUsersQuery = "SELECT DBMS_METADATA.GET_DDL('USER', USERNAME) AS DDL FROM SYS.DBA_USERS WHERE (COMMON='YES' OR UPPER(USERNAME) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y'";
                List<String> commonUsersDDLs = SqlUtils.getDDLStringList("SELECT DBMS_METADATA.GET_DDL('USER', USERNAME) AS DDL FROM SYS.DBA_USERS WHERE (COMMON='YES' OR UPPER(USERNAME) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y'", exeCtx);
                List<String> massagedCommonUsers = has_common_objects.removeDuplicateDDLStatements(commonUsersDDLs);
                String commonProfilesQuery = "SELECT DBMS_METADATA.GET_DDL('PROFILE' , PROFILE) AS DDL FROM SYS.DBA_PROFILES P WHERE COMMON='YES' OR UPPER(PROFILE) LIKE 'C##%'";
                List<String> commonProfilesDDLs = SqlUtils.getDDLStringList("SELECT DBMS_METADATA.GET_DDL('PROFILE' , PROFILE) AS DDL FROM SYS.DBA_PROFILES P WHERE COMMON='YES' OR UPPER(PROFILE) LIKE 'C##%'", exeCtx);
                List<String> massagedProfilesDDLs = has_common_objects.removeDuplicateDDLStatements(commonProfilesDDLs);
                String commonRolesQuery = "SELECT DBMS_METADATA.GET_DDL('ROLE', ROLE) AS DDL FROM SYS.DBA_ROLES WHERE (COMMON='YES' OR UPPER(ROLE) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y' ";
                List<String> commonRolesDDLs = SqlUtils.getDDLStringList("SELECT DBMS_METADATA.GET_DDL('ROLE', ROLE) AS DDL FROM SYS.DBA_ROLES WHERE (COMMON='YES' OR UPPER(ROLE) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y' ", exeCtx);
                List<String> massagedCommonRoles = has_common_objects.removeDuplicateDDLStatements(commonRolesDDLs);
                if (exeCtx.isAutonomousTarget()) {
                    sqlFixup.getNotes().add(this.lang.txt("CHECK.HAS_COMMON_OBJECTS.FIXUP_ADB_PREFIX_NOTE"));
                    sqlFixup.getNotes().add(this.lang.txt("CHECK.HAS_COMMON_OBJECTS.FIXUP_ADB_PASSWORD_NOTE"));
                    massagedCommonUsers = has_common_objects.massageCommonObjectDDL(massagedCommonUsers);
                    massagedProfilesDDLs = has_common_objects.massageCommonObjectDDL(massagedProfilesDDLs);
                    massagedCommonRoles = has_common_objects.massageCommonObjectDDL(massagedCommonRoles);
                    massagedCommonUsers = has_common_objects.massageCreateUserDDLS(massagedCommonUsers);
                } else {
                    massagedProfilesDDLs = has_common_objects.massageCommonProfileDDL(massagedProfilesDDLs);
                }
                String migrationTablespaceMapping = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACE_MAPPING.getKey());
                boolean isADBDTarget = exeCtx.getParsedArgs().getTargetCloud() == TargetCloud.ADWD || exeCtx.getParsedArgs().getTargetCloud() == TargetCloud.ATPD;
                boolean bl = isTablespaceMapping = migrationTablespaceMapping != null && "ALL".equals(migrationTablespaceMapping.trim());
                if (isTablespaceMapping && exeCtx.getAnalysisMode() == AnalysisMode.SCHEMA && (isADBDTarget || !exeCtx.isAutonomousTarget())) {
                    sqlFixup.getNotes().add(this.lang.txt("CHECK.HAS_COMMON_OBJECTS.FIXUP_WORKAROUD_NOTE"));
                }
                fileHelper.writeNotes();
                fileHelper.writeFixupText(massagedProfilesDDLs, 1);
                fileHelper.writeFixupText(massagedCommonUsers, 1);
                fileHelper.writeFixupText(massagedCommonRoles, 1);
                this.addFixup(sqlFixup);
            }
        }
        catch (SQLException e) {
            String errorMsg = Utilities.getErrorText("ERROR3005", e, "create_common_objects", this.getName());
            Utilities.printAndLogErrorMessage(errorMsg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMsg, e);
        }
    }

    private static List<String> removeDuplicateDDLStatements(List<String> list) {
        ArrayList<String> listWithoutDuplicates = new ArrayList<String>();
        for (String item : list) {
            if (listWithoutDuplicates.contains(item)) continue;
            listWithoutDuplicates.add(item);
        }
        return new ArrayList<String>(listWithoutDuplicates);
    }

    private static List<String> massageCommonObjectDDL(List<String> commonObjectDDLS) {
        ArrayList<String> massagedCommonObjectDDLS = new ArrayList<String>();
        for (String commonObjectDDL : commonObjectDDLS) {
            massagedCommonObjectDDLS.add(commonObjectDDL.replace("C##", "C__"));
        }
        return massagedCommonObjectDDLS;
    }

    private static List<String> massageCreateUserDDLS(List<String> createUserDDLS) {
        ArrayList<String> massagedCreateUserDDLS = new ArrayList<String>();
        for (String createUserDDL : createUserDDLS) {
            massagedCreateUserDDLS.add(createUserDDL.replace("IDENTIFIED BY VALUES '.*'", "IDENTIFIED BY <Your-Password-Here>"));
        }
        return massagedCreateUserDDLS;
    }

    private static List<String> massageCommonProfileDDL(List<String> profilesDLLs) {
        ArrayList<String> massagedCommonProfile = new ArrayList<String>();
        for (String profile : profilesDLLs) {
            profile = profile.replaceFirst(";", "\n");
            profile = profile.concat("CONTAINER=ALL;");
            massagedCommonProfile.add(profile);
        }
        return massagedCommonProfile;
    }
}

