/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class gg_has_low_streams_pool_size
extends Check
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(gg_has_low_streams_pool_size.class.getName());
    protected static final long MIN_STREAMS_POOL_SIZE = 0x50000000L;
    protected static final long MIN_SHARED_POOL_SIZE = 0x280000000L;
    private static final List<String> PARAMS = Arrays.asList("streams_pool_size", "shared_pool_size", "sga_target", "memory_target");

    public gg_has_low_streams_pool_size() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Collections.singletonList(MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT LOWER(NAME) AS NAME,CAST(VALUE AS VARCHAR2(100)) AS VALUE FROM V$PARAMETER " + SqlUtils.createWhereInClause("LOWER(NAME)", PARAMS));
    }

    @Override
    public CheckResult determineResult() {
        if (this.getRelevantObjectsData() == null || this.getRelevantObjectsData().size() != PARAMS.size()) {
            this.processInvalidValue("Database Parameters");
            return CheckResult.FATAL;
        }
        long streamsPoolSize = 0L;
        long sharedPoolSize = 0L;
        long sgaTarget = 0L;
        long memoryTarget = 0L;
        block14: for (int i = 0; i < PARAMS.size(); ++i) {
            long numValue;
            String key = this.getRelevantObjectsData().get(i).get("NAME");
            String strValue = this.getRelevantObjectsData().get(i).get("VALUE");
            try {
                numValue = Utilities.stringToLong(strValue);
            }
            catch (Exception e) {
                this.processInvalidValue(key, e);
                return CheckResult.FATAL;
            }
            switch (key) {
                case "streams_pool_size": {
                    streamsPoolSize = numValue;
                    continue block14;
                }
                case "shared_pool_size": {
                    sharedPoolSize = numValue;
                    continue block14;
                }
                case "sga_target": {
                    sgaTarget = numValue;
                    continue block14;
                }
                case "memory_target": {
                    memoryTarget = numValue;
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected key: " + key);
                }
            }
        }
        log.trace("using " + streamsPoolSize + " as " + "streams_pool_size");
        log.trace("using " + sharedPoolSize + " as " + "shared_pool_size");
        log.trace("using " + sgaTarget + " as " + "sga_target");
        log.trace("using " + memoryTarget + " as " + "memory_target");
        if (streamsPoolSize >= 0x50000000L || sharedPoolSize >= 0x280000000L || sgaTarget > 0L || memoryTarget > 0L) {
            return CheckResult.PASS;
        }
        return CheckResult.WARNING;
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "gg_set_streams_pool_size";
        Fixup.Locus locus = Fixup.Locus.source;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("gg_set_streams_pool_size", locus, parentFolderPath).runAtCDBLevel(exeCtx.isDatabaseIsCDB()).restartRequired(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

