/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.supplemental;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class HybridColumnarCompressionTable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(HybridColumnarCompressionTable.class.getName());
    @HtmlProperty(labelKey="SRC_HCC_TABLE_OWNER", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the table with Hybrid Columnar Compression")
    private String owner;
    @HtmlProperty(labelKey="SRC_HCC_TABLE_NAME", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the table with Hybrid Columnar Compression")
    private String tableName;
    @HtmlProperty(labelKey="SRC_HCC_COMPRESS_FOR", section=HtmlReportSectionName.SRC_SUPPLEMENTAL_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of compression; typically 'QUERY HIGH','QUERY LOW','ARCHIVE HIGH', or 'ARCHIVE LOW'")
    private String compressFor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HybridColumnarCompressionTable> getHCCTableData(ExecutionContext exeCtx) throws SQLException {
        ArrayList<HybridColumnarCompressionTable> hccTableData = new ArrayList<HybridColumnarCompressionTable>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String hccTablesQuery = "SELECT OWNER, TABLE_NAME, COMPRESS_FOR FROM SYS.DBA_TABLES " + whereClause + " AND COMPRESSION='ENABLED' AND COMPRESS_FOR IN ('QUERY HIGH','QUERY LOW','ARCHIVE HIGH','ARCHIVE LOW') ORDER BY 1,2";
        log.fine("Fetching HCC table data with query: " + hccTablesQuery);
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, hccTablesQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tableOwner = rs.getString("OWNER");
                String tableName = rs.getString("TABLE_NAME");
                String compressFor = rs.getString("COMPRESS_FOR");
                HybridColumnarCompressionTable hccTable = new HybridColumnarCompressionTable(tableOwner, tableName, compressFor);
                hccTableData.add(hccTable);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        log.fine("Count of HCC tables: " + hccTableData.size());
        return hccTableData;
    }

    public static HybridColumnarCompressionTable createEmptyHCCTableInstance() {
        return HybridColumnarCompressionTable.builder().build();
    }

    public static HybridColumnarCompressionTableBuilder builder() {
        return new HybridColumnarCompressionTableBuilder();
    }

    private HybridColumnarCompressionTable(String owner, String tableName, String compressFor) {
        this.owner = owner;
        this.tableName = tableName;
        this.compressFor = compressFor;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCompressFor() {
        return this.compressFor;
    }

    public static class HybridColumnarCompressionTableBuilder {
        private String owner;
        private String tableName;
        private String compressFor;

        HybridColumnarCompressionTableBuilder() {
        }

        public HybridColumnarCompressionTableBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public HybridColumnarCompressionTableBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public HybridColumnarCompressionTableBuilder compressFor(String compressFor) {
            this.compressFor = compressFor;
            return this;
        }

        public HybridColumnarCompressionTable build() {
            return new HybridColumnarCompressionTable(this.owner, this.tableName, this.compressFor);
        }

        public String toString() {
            return "HybridColumnarCompressionTable.HybridColumnarCompressionTableBuilder(owner=" + this.owner + ", tableName=" + this.tableName + ", compressFor=" + this.compressFor + ")";
        }
    }
}

