/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ReservedTablespaceSegments {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ReservedTablespaceSegments.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the segment")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEG_TYPE", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of the segment")
    private String segmentType;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TBS_NAME", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the tablespace")
    private String tablespaceName;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEGMENTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of segments")
    private long segments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReservedTablespaceSegments> getSegmentDistributionStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        String query = "SELECT /*+  NO_MERGE  */       S.OWNER, S.SEGMENT_TYPE, S.TABLESPACE_NAME, COUNT(1) AS SEGMENTS  FROM SYS.DBA_SEGMENTS S" + whereClause + "   AND S.TABLESPACE_NAME IN ('SYSTEM','SYSAUX','TEMP','TEMPORARY','RBS','ROLLBACK','ROLLBACKS','RBSEGS')   AND S.TABLESPACE_NAME NOT IN        (SELECT TABLESPACE_NAME FROM DBA_TABLESPACES         WHERE CONTENTS IN ('UNDO','TEMPORARY')) GROUP BY S.OWNER, S.SEGMENT_TYPE, S.TABLESPACE_NAME ORDER BY 1,2,3";
        log.fine("Fetching Reserved Tablespace Segments stats with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ReservedTablespaceSegments> segmentDistributions = new ArrayList<ReservedTablespaceSegments>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ReservedTablespaceSegments segmentDist = new ReservedTablespaceSegments(rs.getString("OWNER"), rs.getString("SEGMENT_TYPE"), rs.getString("TABLESPACE_NAME"), rs.getLong("SEGMENTS"));
                segmentDistributions.add(segmentDist);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return segmentDistributions;
    }

    public static ReservedTablespaceSegmentsBuilder builder() {
        return new ReservedTablespaceSegmentsBuilder();
    }

    private ReservedTablespaceSegments(String owner, String segmentType, String tablespaceName, long segments) {
        this.owner = owner;
        this.segmentType = segmentType;
        this.tablespaceName = tablespaceName;
        this.segments = segments;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSegmentType() {
        return this.segmentType;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public long getSegments() {
        return this.segments;
    }

    public static class ReservedTablespaceSegmentsBuilder {
        private String owner;
        private String segmentType;
        private String tablespaceName;
        private long segments;

        ReservedTablespaceSegmentsBuilder() {
        }

        public ReservedTablespaceSegmentsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public ReservedTablespaceSegmentsBuilder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        public ReservedTablespaceSegmentsBuilder tablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
            return this;
        }

        public ReservedTablespaceSegmentsBuilder segments(long segments) {
            this.segments = segments;
            return this;
        }

        public ReservedTablespaceSegments build() {
            return new ReservedTablespaceSegments(this.owner, this.segmentType, this.tablespaceName, this.segments);
        }

        public String toString() {
            return "ReservedTablespaceSegments.ReservedTablespaceSegmentsBuilder(owner=" + this.owner + ", segmentType=" + this.segmentType + ", tablespaceName=" + this.tablespaceName + ", segments=" + this.segments + ")";
        }
    }
}

