/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ApplicationSchemaObjects {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ApplicationSchemaObjects.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the object")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TABLES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of tables owned by the user")
    private int tables;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TABLE_PARTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of table partitions owned by the user")
    private int tablePartitions;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SUBPARTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of table sub-partitions owned by the user")
    private int tableSubpartitions;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_INDEXES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of indexes owned by the user")
    private int indexes;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_INDEX_PARTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of index partitions owned by the user")
    private int indexPartitions;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_IND_SPARTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of index sub-partitions owned by the user")
    private int indexSubpartitions;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_VIEWS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of views owned by the user")
    private int views;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_MAT_VIEWS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of materialized views owned by the user")
    private int materializedViews;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TRIGGERS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of triggers owned by the user")
    private int triggers;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_PACKAGES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of packages owned by the user")
    private int packages;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_PROCEDURES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of procedures owned by the user")
    private int procedures;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_FUNCTIONS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of functions owned by the user")
    private int functions;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_LIBRARIES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of libraries owned by the user")
    private int libraries;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SYNONYMS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of synonyms owned by the user")
    private int synonyms;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TYPES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of types owned by the user")
    private int types;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEQUENCES", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The number of sequences owned by the user")
    private int sequences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ApplicationSchemaObjects> getApplicationSchemaObjectStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String query = "SELECT /*+  NO_MERGE  */        OWNER,        SUM(CASE OBJECT_TYPE WHEN 'TABLE' THEN 1 ELSE 0 END) TABLES,        SUM(CASE OBJECT_TYPE WHEN 'TABLE PARTITION' THEN 1 ELSE 0 END) TABLE_PARTITIONS,        SUM(CASE OBJECT_TYPE WHEN 'TABLE SUBPARTITION' THEN 1 ELSE 0 END) TABLE_SUBPARTITIONS,        SUM(CASE OBJECT_TYPE WHEN 'INDEX' THEN 1 ELSE 0 END) INDEXES,        SUM(CASE OBJECT_TYPE WHEN 'INDEX PARTITION' THEN 1 ELSE 0 END) INDEX_PARTITIONS,        SUM(CASE OBJECT_TYPE WHEN 'INDEX SUBPARTITION' THEN 1 ELSE 0 END) INDEX_SUBPARTITIONS,        SUM(CASE OBJECT_TYPE WHEN 'VIEW' THEN 1 ELSE 0 END) VIEWS,        SUM(CASE OBJECT_TYPE WHEN 'MATERIALIZED VIEW' THEN 1 ELSE 0 END) MATERIALIZED_VIEWS,        SUM(CASE OBJECT_TYPE WHEN 'TRIGGER' THEN 1 ELSE 0 END) TRIGGERS,        SUM(CASE OBJECT_TYPE WHEN 'PACKAGE' THEN 1 ELSE 0 END) PACKAGES,        SUM(CASE OBJECT_TYPE WHEN 'PROCEDURE' THEN 1 ELSE 0 END) PROCEDURES,        SUM(CASE OBJECT_TYPE WHEN 'FUNCTION' THEN 1 ELSE 0 END) FUNCTIONS,        SUM(CASE OBJECT_TYPE WHEN 'LIBRARY' THEN 1 ELSE 0 END) LIBRARIES,        SUM(CASE OBJECT_TYPE WHEN 'SYNONYM' THEN 1 ELSE 0 END) SYNONYMS,        SUM(CASE OBJECT_TYPE WHEN 'TYPE' THEN 1 ELSE 0 END) TYPES,        SUM(CASE OBJECT_TYPE WHEN 'SEQUENCE' THEN 1 ELSE 0 END) SEQUENCES   FROM DBA_OBJECTS " + whereClause + "   AND OBJECT_TYPE IN ('TABLE', 'TABLE PARTITION', 'TABLE SUBPARTITION', 'INDEX', 'INDEX PARTITION', 'INDEX SUBPARTITION', 'VIEW',                        'MATERIALIZED VIEW', 'TRIGGER', 'PACKAGE', 'PROCEDURE', 'FUNCTION', 'LIBRARY', 'SYNONYM', 'TYPE', 'SEQUENCE')  GROUP BY OWNER  ORDER BY OWNER";
        log.fine("Fetching Application Schema Object stats with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ApplicationSchemaObjects> applicationSchemaObjectStats = new ArrayList<ApplicationSchemaObjects>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ApplicationSchemaObjects appSchemaObj = new ApplicationSchemaObjects(rs.getString("OWNER"), rs.getInt("TABLES"), rs.getInt("TABLE_PARTITIONS"), rs.getInt("TABLE_SUBPARTITIONS"), rs.getInt("INDEXES"), rs.getInt("INDEX_PARTITIONS"), rs.getInt("INDEX_SUBPARTITIONS"), rs.getInt("VIEWS"), rs.getInt("MATERIALIZED_VIEWS"), rs.getInt("TRIGGERS"), rs.getInt("PACKAGES"), rs.getInt("PROCEDURES"), rs.getInt("FUNCTIONS"), rs.getInt("LIBRARIES"), rs.getInt("SYNONYMS"), rs.getInt("TYPES"), rs.getInt("SEQUENCES"));
                applicationSchemaObjectStats.add(appSchemaObj);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return applicationSchemaObjectStats;
    }

    public static ApplicationSchemaObjectsBuilder builder() {
        return new ApplicationSchemaObjectsBuilder();
    }

    private ApplicationSchemaObjects(String owner, int tables, int tablePartitions, int tableSubpartitions, int indexes, int indexPartitions, int indexSubpartitions, int views, int materializedViews, int triggers, int packages, int procedures, int functions, int libraries, int synonyms, int types, int sequences) {
        this.owner = owner;
        this.tables = tables;
        this.tablePartitions = tablePartitions;
        this.tableSubpartitions = tableSubpartitions;
        this.indexes = indexes;
        this.indexPartitions = indexPartitions;
        this.indexSubpartitions = indexSubpartitions;
        this.views = views;
        this.materializedViews = materializedViews;
        this.triggers = triggers;
        this.packages = packages;
        this.procedures = procedures;
        this.functions = functions;
        this.libraries = libraries;
        this.synonyms = synonyms;
        this.types = types;
        this.sequences = sequences;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getTables() {
        return this.tables;
    }

    public int getTablePartitions() {
        return this.tablePartitions;
    }

    public int getTableSubpartitions() {
        return this.tableSubpartitions;
    }

    public int getIndexes() {
        return this.indexes;
    }

    public int getIndexPartitions() {
        return this.indexPartitions;
    }

    public int getIndexSubpartitions() {
        return this.indexSubpartitions;
    }

    public int getViews() {
        return this.views;
    }

    public int getMaterializedViews() {
        return this.materializedViews;
    }

    public int getTriggers() {
        return this.triggers;
    }

    public int getPackages() {
        return this.packages;
    }

    public int getProcedures() {
        return this.procedures;
    }

    public int getFunctions() {
        return this.functions;
    }

    public int getLibraries() {
        return this.libraries;
    }

    public int getSynonyms() {
        return this.synonyms;
    }

    public int getTypes() {
        return this.types;
    }

    public int getSequences() {
        return this.sequences;
    }

    public static class ApplicationSchemaObjectsBuilder {
        private String owner;
        private int tables;
        private int tablePartitions;
        private int tableSubpartitions;
        private int indexes;
        private int indexPartitions;
        private int indexSubpartitions;
        private int views;
        private int materializedViews;
        private int triggers;
        private int packages;
        private int procedures;
        private int functions;
        private int libraries;
        private int synonyms;
        private int types;
        private int sequences;

        ApplicationSchemaObjectsBuilder() {
        }

        public ApplicationSchemaObjectsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public ApplicationSchemaObjectsBuilder tables(int tables) {
            this.tables = tables;
            return this;
        }

        public ApplicationSchemaObjectsBuilder tablePartitions(int tablePartitions) {
            this.tablePartitions = tablePartitions;
            return this;
        }

        public ApplicationSchemaObjectsBuilder tableSubpartitions(int tableSubpartitions) {
            this.tableSubpartitions = tableSubpartitions;
            return this;
        }

        public ApplicationSchemaObjectsBuilder indexes(int indexes) {
            this.indexes = indexes;
            return this;
        }

        public ApplicationSchemaObjectsBuilder indexPartitions(int indexPartitions) {
            this.indexPartitions = indexPartitions;
            return this;
        }

        public ApplicationSchemaObjectsBuilder indexSubpartitions(int indexSubpartitions) {
            this.indexSubpartitions = indexSubpartitions;
            return this;
        }

        public ApplicationSchemaObjectsBuilder views(int views) {
            this.views = views;
            return this;
        }

        public ApplicationSchemaObjectsBuilder materializedViews(int materializedViews) {
            this.materializedViews = materializedViews;
            return this;
        }

        public ApplicationSchemaObjectsBuilder triggers(int triggers) {
            this.triggers = triggers;
            return this;
        }

        public ApplicationSchemaObjectsBuilder packages(int packages) {
            this.packages = packages;
            return this;
        }

        public ApplicationSchemaObjectsBuilder procedures(int procedures) {
            this.procedures = procedures;
            return this;
        }

        public ApplicationSchemaObjectsBuilder functions(int functions) {
            this.functions = functions;
            return this;
        }

        public ApplicationSchemaObjectsBuilder libraries(int libraries) {
            this.libraries = libraries;
            return this;
        }

        public ApplicationSchemaObjectsBuilder synonyms(int synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public ApplicationSchemaObjectsBuilder types(int types) {
            this.types = types;
            return this;
        }

        public ApplicationSchemaObjectsBuilder sequences(int sequences) {
            this.sequences = sequences;
            return this;
        }

        public ApplicationSchemaObjects build() {
            return new ApplicationSchemaObjects(this.owner, this.tables, this.tablePartitions, this.tableSubpartitions, this.indexes, this.indexPartitions, this.indexSubpartitions, this.views, this.materializedViews, this.triggers, this.packages, this.procedures, this.functions, this.libraries, this.synonyms, this.types, this.sequences);
        }

        public String toString() {
            return "ApplicationSchemaObjects.ApplicationSchemaObjectsBuilder(owner=" + this.owner + ", tables=" + this.tables + ", tablePartitions=" + this.tablePartitions + ", tableSubpartitions=" + this.tableSubpartitions + ", indexes=" + this.indexes + ", indexPartitions=" + this.indexPartitions + ", indexSubpartitions=" + this.indexSubpartitions + ", views=" + this.views + ", materializedViews=" + this.materializedViews + ", triggers=" + this.triggers + ", packages=" + this.packages + ", procedures=" + this.procedures + ", functions=" + this.functions + ", libraries=" + this.libraries + ", synonyms=" + this.synonyms + ", types=" + this.types + ", sequences=" + this.sequences + ")";
        }
    }
}

