/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.redo;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StandByLogs {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(StandByLogs.class.getName());
    @HtmlProperty(labelKey="SRC_LOGS_THREAD_NUM", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Log thread number.")
    private Integer threadNumber;
    @HtmlProperty(labelKey="SRC_LOGS_GROUP_NUM", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Log group number.")
    private Integer groupNumber;
    @HtmlProperty(labelKey="SRC_LOGS_SEQ_NUM", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Log sequence number.")
    private Integer sequenceNumber;
    @HtmlProperty(labelKey="SRC_LOGS_BYTES", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the log (in MB).")
    private Double logSizeInMB;
    @HtmlProperty(labelKey="SRC_LOGS_ARCHIVED", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Identifies whether the log is archived.")
    private String archived;
    @HtmlProperty(labelKey="SRC_LOGS_STATUS", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Identified the status of the log.")
    private String status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StandByLogs> getStandByLogs(ExecutionContext exeCtx) throws SQLException {
        ArrayList<StandByLogs> standByLogs = new ArrayList<StandByLogs>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sbLogsQuery = "SELECT   THREAD#,   GROUP#,   SEQUENCE#,   CASE     WHEN  ROUND(BYTES / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024, 1)     WHEN  ROUND(BYTES / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024, 2)     WHEN  ROUND(BYTES / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024, 3)     ELSE ROUND(BYTES / 1024 / 1024, 4)   END AS MBYTES,   ARCHIVED,   STATUS FROM V$STANDBY_LOG ORDER BY THREAD#, GROUP#";
        log.fine("Fetching stand by log details with query: SELECT   THREAD#,   GROUP#,   SEQUENCE#,   CASE     WHEN  ROUND(BYTES / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024, 1)     WHEN  ROUND(BYTES / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024, 2)     WHEN  ROUND(BYTES / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024, 3)     ELSE ROUND(BYTES / 1024 / 1024, 4)   END AS MBYTES,   ARCHIVED,   STATUS FROM V$STANDBY_LOG ORDER BY THREAD#, GROUP#");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   THREAD#,   GROUP#,   SEQUENCE#,   CASE     WHEN  ROUND(BYTES / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024, 1)     WHEN  ROUND(BYTES / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024, 2)     WHEN  ROUND(BYTES / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024, 3)     ELSE ROUND(BYTES / 1024 / 1024, 4)   END AS MBYTES,   ARCHIVED,   STATUS FROM V$STANDBY_LOG ORDER BY THREAD#, GROUP#");
            rs = stmt.executeQuery();
            while (rs.next()) {
                standByLogs.add(StandByLogs.builder().threadNumber(rs.getInt("THREAD#")).groupNumber(rs.getInt("GROUP#")).sequenceNumber(rs.getInt("SEQUENCE#")).logSizeInMB(rs.getDouble("MBYTES")).archived(rs.getString("ARCHIVED")).status(rs.getString("STATUS")).build());
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return standByLogs;
    }

    public static StandByLogs createEmptyStandByLogsInstance() {
        return new StandByLogs(0, 0, 0, 0.0, "", "");
    }

    public static StandByLogsBuilder builder() {
        return new StandByLogsBuilder();
    }

    private StandByLogs(Integer threadNumber, Integer groupNumber, Integer sequenceNumber, Double logSizeInMB, String archived, String status) {
        this.threadNumber = threadNumber;
        this.groupNumber = groupNumber;
        this.sequenceNumber = sequenceNumber;
        this.logSizeInMB = logSizeInMB;
        this.archived = archived;
        this.status = status;
    }

    public Integer getThreadNumber() {
        return this.threadNumber;
    }

    public Integer getGroupNumber() {
        return this.groupNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Double getLogSizeInMB() {
        return this.logSizeInMB;
    }

    public String getArchived() {
        return this.archived;
    }

    public String getStatus() {
        return this.status;
    }

    public static class StandByLogsBuilder {
        private Integer threadNumber;
        private Integer groupNumber;
        private Integer sequenceNumber;
        private Double logSizeInMB;
        private String archived;
        private String status;

        StandByLogsBuilder() {
        }

        public StandByLogsBuilder threadNumber(Integer threadNumber) {
            this.threadNumber = threadNumber;
            return this;
        }

        public StandByLogsBuilder groupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public StandByLogsBuilder sequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public StandByLogsBuilder logSizeInMB(Double logSizeInMB) {
            this.logSizeInMB = logSizeInMB;
            return this;
        }

        public StandByLogsBuilder archived(String archived) {
            this.archived = archived;
            return this;
        }

        public StandByLogsBuilder status(String status) {
            this.status = status;
            return this;
        }

        public StandByLogs build() {
            return new StandByLogs(this.threadNumber, this.groupNumber, this.sequenceNumber, this.logSizeInMB, this.archived, this.status);
        }

        public String toString() {
            return "StandByLogs.StandByLogsBuilder(threadNumber=" + this.threadNumber + ", groupNumber=" + this.groupNumber + ", sequenceNumber=" + this.sequenceNumber + ", logSizeInMB=" + this.logSizeInMB + ", archived=" + this.archived + ", status=" + this.status + ")";
        }
    }
}

