/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.redo;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RedoHistory {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(RedoHistory.class.getName());
    @HtmlProperty(labelKey="SRC_REDO_HISTORY_THREAD_ID", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The Redo thread number")
    private int threadId;
    @HtmlProperty(labelKey="SRC_REDO_HISTORY_COMPLETION_DATE", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The date when the archiving completed in ISO_DATE_TIME format. For example: 2024-09-20T00:00:00Z")
    private Date completionDate;
    @HtmlProperty(labelKey="SRC_REDO_HISTORY_NUM_ARCHIVE_LOGS", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The Number of Archive Logs")
    private int numArchiveLogs;
    @HtmlProperty(labelKey="SRC_REDO_HISTORY_SIZE_IN_MB", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Sum of the logs in Megabytes")
    private Double sizeInMB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RedoHistory> getRedoHistory(ExecutionContext exeCtx) throws SQLException {
        String redoRecordQuery = "WITH dest AS(  SELECT /*+ MATERIALIZE */    nvl(      (SELECT dest_id FROM v$archive_dest_status        WHERE status = 'VALID' AND type = 'LOCAL' AND ROWNUM = 1),      (SELECT nvl(MIN(dest_id), 1) dest_id_min        FROM v$archive_dest_status        WHERE status = 'VALID')    ) dest_id_int  FROM dual) SELECT  v.thread#                           AS THREAD_ID,  trunc(v.completion_time)            AS COMPLETION_DATE,  COUNT(1)                            AS NUM_ARCHIVE_LOGS,  CASE     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 1) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 1)     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 2) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 2)     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 3) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 3)     ELSE ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 4)   END AS SIZE_IN_MB FROM  v$archived_log v,  dest           d WHERE    v.dest_id = d.dest_id_int  AND v.first_time > trunc(sysdate - 31)  AND v.first_time < trunc(sysdate) GROUP BY  v.thread#,  trunc(v.completion_time) ORDER BY  2,  1";
        ArrayList<RedoHistory> redoHistories = new ArrayList<RedoHistory>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            log.fine("Fetching Redo history with query: WITH dest AS(  SELECT /*+ MATERIALIZE */    nvl(      (SELECT dest_id FROM v$archive_dest_status        WHERE status = 'VALID' AND type = 'LOCAL' AND ROWNUM = 1),      (SELECT nvl(MIN(dest_id), 1) dest_id_min        FROM v$archive_dest_status        WHERE status = 'VALID')    ) dest_id_int  FROM dual) SELECT  v.thread#                           AS THREAD_ID,  trunc(v.completion_time)            AS COMPLETION_DATE,  COUNT(1)                            AS NUM_ARCHIVE_LOGS,  CASE     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 1) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 1)     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 2) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 2)     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 3) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 3)     ELSE ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 4)   END AS SIZE_IN_MB FROM  v$archived_log v,  dest           d WHERE    v.dest_id = d.dest_id_int  AND v.first_time > trunc(sysdate - 31)  AND v.first_time < trunc(sysdate) GROUP BY  v.thread#,  trunc(v.completion_time) ORDER BY  2,  1");
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "WITH dest AS(  SELECT /*+ MATERIALIZE */    nvl(      (SELECT dest_id FROM v$archive_dest_status        WHERE status = 'VALID' AND type = 'LOCAL' AND ROWNUM = 1),      (SELECT nvl(MIN(dest_id), 1) dest_id_min        FROM v$archive_dest_status        WHERE status = 'VALID')    ) dest_id_int  FROM dual) SELECT  v.thread#                           AS THREAD_ID,  trunc(v.completion_time)            AS COMPLETION_DATE,  COUNT(1)                            AS NUM_ARCHIVE_LOGS,  CASE     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 1) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 1)     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 2) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 2)     WHEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 3) > 0 THEN ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 3)     ELSE ROUND(SUM(v.blocks * v.block_size)/ 1024 / 1024, 4)   END AS SIZE_IN_MB FROM  v$archived_log v,  dest           d WHERE    v.dest_id = d.dest_id_int  AND v.first_time > trunc(sysdate - 31)  AND v.first_time < trunc(sysdate) GROUP BY  v.thread#,  trunc(v.completion_time) ORDER BY  2,  1");
            rs = stmt.executeQuery();
            while (rs.next()) {
                int threadId = rs.getInt("THREAD_ID");
                java.sql.Date completionDate = rs.getDate("COMPLETION_DATE");
                int numArchiveLogs = rs.getInt("NUM_ARCHIVE_LOGS");
                double sizeInMB = rs.getDouble("SIZE_IN_MB");
                RedoHistory redoHistory = new RedoHistory(threadId, completionDate, numArchiveLogs, sizeInMB);
                redoHistories.add(redoHistory);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return redoHistories;
    }

    public static RedoHistory createEmptyRedoHistoryInstance() {
        return new RedoHistory(0, new Date(), 0, 0.0);
    }

    private RedoHistory(int threadId, Date completionDate, int numArchiveLogs, Double sizeInMB) {
        this.threadId = threadId;
        this.completionDate = completionDate;
        this.numArchiveLogs = numArchiveLogs;
        this.sizeInMB = sizeInMB;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public int getNumArchiveLogs() {
        return this.numArchiveLogs;
    }

    public Double getSizeInMB() {
        return this.sizeInMB;
    }
}

