/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.io;

import com.oracle.premigration.logger.PremigrationLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ResourceFinder {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ResourceFinder.class.getName());
    private final String resourceName;
    private static final String resourceLocation = "/";

    public ResourceFinder(String resourceName) {
        if (resourceName.contains("\\")) {
            log.severe("illegal argument " + resourceName);
        }
        this.resourceName = resourceName;
    }

    public InputStream getResourceAsStream() {
        InputStream resourceStream = null;
        String resourcePath = resourceLocation + this.resourceName;
        if (this.getClass().getResource(resourcePath) != null) {
            resourceStream = this.getClass().getResourceAsStream(resourcePath);
        }
        if (resourceStream == null) {
            log.severe("resourceStream is null [" + resourcePath + "]");
        }
        return resourceStream;
    }

    public String getResourceAsText() {
        StringBuilder content = new StringBuilder();
        try (InputStream is = this.getResourceAsStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            log.severe("Unable to read resource file.");
            e.printStackTrace();
        }
        return content.toString();
    }
}

