/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.reports.text.ReportNotes;
import java.util.ArrayList;
import java.util.List;

public enum ReportNote {
    RELEVANT_OBJECT("CHECK_RELEVANT_OBJECT_LEGEND");

    private static final Language lang;
    private final String textKey;

    private ReportNote(String textKey) {
        this.textKey = textKey;
    }

    public String toString() {
        return lang.txt(this.textKey);
    }

    public static List<ReportNotes> toReportNotesList() {
        ArrayList<String> noteTexts = new ArrayList<String>();
        ArrayList<ReportNotes> notesList = new ArrayList<ReportNotes>();
        for (ReportNote reportNote : ReportNote.values()) {
            noteTexts.add(reportNote.toString());
        }
        int numeration = 0;
        for (String note : noteTexts) {
            String numerationStr = "" + ++numeration;
            notesList.add(new ReportNotes(numerationStr, note));
        }
        return notesList;
    }

    static {
        lang = Language.getInstance();
    }
}

