/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli;

import com.oracle.premigration.cli.CliOption;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.enums.GatherDetailsOptions;
import com.oracle.premigration.commons.enums.LoggingLevel;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.ResultLevel;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.lang.Language;
import java.io.Console;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandParser {
    private static final Language lang = Language.getInstance();
    private final Options helpOptions = new Options();
    private final Options sourceOptions = new Options();
    private final Options targetOptions = new Options();
    private final Options updateOptions = new Options();
    private final Options configurationFileOptions = new Options();
    private final Options visibleSourceOptions = new Options();

    public CommandParser() {
        OptionGroup helpGroup = this.createGroup(CliOption.HELP, CliOption.VERSION);
        this.helpOptions.addOptionGroup(helpGroup);
        OptionGroup updateGroup = this.createGroup(CliOption.SIMPLE_VERSION, CliOption.COMPARE_VERSION, CliOption.UPDATE_CHECK);
        this.updateOptions.addOptionGroup(updateGroup);
        CliOption[] commonOptions = new CliOption[]{CliOption.CONNECT_STRING, CliOption.USERNAME, CliOption.SYSDBA, CliOption.PDBNAME, CliOption.OUTDIR, CliOption.OUTFILEPREFIX, CliOption.LOGGINGLEVEL, CliOption.QUIET, CliOption.ZIP};
        this.addOptions(this.sourceOptions, commonOptions);
        this.addOptions(this.visibleSourceOptions, commonOptions);
        this.addOptions(this.targetOptions, commonOptions);
        OptionGroup schemasGroup = this.createGroup(CliOption.SCHEMAS, CliOption.EXCLUDE_SCHEMAS);
        this.sourceOptions.addOptionGroup(schemasGroup);
        this.visibleSourceOptions.addOptionGroup(schemasGroup);
        CliOption[] visibleOptions = new CliOption[]{CliOption.TARGET_CLOUD, CliOption.FULL, CliOption.MIGRATION_METHOD, CliOption.ANALYSISPROPS, CliOption.REPORT_FORMAT, CliOption.MAXTEXTROWS, CliOption.SQL_IN_TEXT_REPORT, CliOption.MAXRELEVANTOBJECTS, CliOption.RESULT_LEVEL, CliOption.GENFIXUPS, CliOption.MAXSUBPROCESSES, CliOption.GATHERDETAILS};
        CliOption[] hiddenOptions = new CliOption[]{CliOption.CPATKEY};
        this.addOptions(this.visibleSourceOptions, visibleOptions);
        this.addOptions(this.sourceOptions, visibleOptions);
        this.addOptions(this.sourceOptions, hiddenOptions);
        this.addOptions(this.targetOptions, CliOption.GETTARGETPROPS);
        this.addOptions(this.configurationFileOptions, CliOption.PARFILE, CliOption.LOADPASSWORD, CliOption.NOCONSOLE, CliOption.OUTDIR, CliOption.OUTFILEPREFIX);
    }

    public CommandLineArgs parse(String[] arguments) throws ParseException {
        String outFilePrefix;
        DefaultParser parser = new DefaultParser();
        CommandLine helpCmd = parser.parse(this.helpOptions, arguments, true);
        if (arguments.length == 0 || helpCmd.hasOption(CliOption.HELP.getLongOpt()) || helpCmd.hasOption(CliOption.VERSION.getLongOpt())) {
            boolean help = arguments.length == 0 || helpCmd.hasOption(CliOption.HELP.getLongOpt());
            return CommandLineArgs.builder().outdir(CommandParser.getDefaultOutputDirectory()).help(help).version(helpCmd.hasOption(CliOption.VERSION.getLongOpt())).build();
        }
        CommandLine updateCmd = parser.parse(this.updateOptions, arguments, true);
        if (updateCmd.hasOption(CliOption.SIMPLE_VERSION.getLongOpt()) || updateCmd.hasOption(CliOption.COMPARE_VERSION.getLongOpt()) || updateCmd.hasOption(CliOption.UPDATE_CHECK.getLongOpt())) {
            String compareVersion = updateCmd.hasOption(CliOption.COMPARE_VERSION.getLongOpt()) ? CommandParser.getLatestOptionForArg(updateCmd, CliOption.COMPARE_VERSION.getLongOpt()) : null;
            return CommandLineArgs.builder().outdir(CommandParser.getDefaultOutputDirectory()).simpleVersion(updateCmd.hasOption(CliOption.SIMPLE_VERSION.getLongOpt())).compareVersion(compareVersion).checkForUpdates(updateCmd.hasOption(CliOption.UPDATE_CHECK.getLongOpt())).build();
        }
        CommandLine parFileCmd = parser.parse(this.configurationFileOptions, arguments, true);
        String parameterFile = parFileCmd.hasOption(CliOption.PARFILE.getLongOpt()) ? CommandParser.getLatestOptionForArg(parFileCmd, CliOption.PARFILE.getLongOpt()) : null;
        boolean loadPassword = parFileCmd.hasOption(CliOption.LOADPASSWORD.getLongOpt());
        boolean noconsole = parFileCmd.hasOption(CliOption.NOCONSOLE.getLongOpt());
        String outdir = parFileCmd.hasOption(CliOption.OUTDIR.getLongOpt()) ? CommandParser.getLatestOptionForArg(parFileCmd, CliOption.OUTDIR.getLongOpt()) : CommandParser.getDefaultOutputDirectory();
        String string = outFilePrefix = parFileCmd.hasOption(CliOption.OUTFILEPREFIX.getLongOpt()) ? CommandParser.getLatestOptionForArg(parFileCmd, CliOption.OUTFILEPREFIX.getLongOpt()) : null;
        if (parameterFile != null && !parameterFile.isEmpty()) {
            CommandLineArgs.CommandLineArgsBuilder parBuilder = CommandLineArgs.builder();
            parBuilder = CommandParser.buildCommonArgs(parBuilder, parFileCmd);
            return parBuilder.configurationFile(parameterFile).loadPassword(loadPassword).noconsole(noconsole).outdir(outdir).outFilePrefix(outFilePrefix).build();
        }
        try {
            CommandLine targetCmd = parser.parse(this.targetOptions, arguments);
            CommandLineArgs.CommandLineArgsBuilder targetBuilder = CommandLineArgs.builder();
            targetBuilder = CommandParser.buildCommonArgs(targetBuilder, targetCmd);
            return CommandParser.buildTargetArgs(targetBuilder, targetCmd).build();
        }
        catch (ParseException pe) {
            List<String> argList = Arrays.asList(arguments);
            if (argList.contains("--" + CliOption.GETTARGETPROPS.getLongOpt()) || argList.contains("-" + CliOption.GETTARGETPROPS.getOpt())) {
                throw pe;
            }
            try {
                CommandLine sourceCmd = parser.parse(this.sourceOptions, arguments);
                CommandLineArgs.CommandLineArgsBuilder sourceBuilder = CommandLineArgs.builder();
                sourceBuilder = CommandParser.buildCommonArgs(sourceBuilder, sourceCmd);
                return CommandParser.buildSourceArgs(sourceBuilder, sourceCmd).build();
            }
            catch (NumberFormatException e) {
                ParseException pe2 = new ParseException(e.getLocalizedMessage());
                pe2.initCause((Throwable)e);
                throw pe2;
            }
        }
    }

    private static CommandLineArgs.CommandLineArgsBuilder buildCommonArgs(CommandLineArgs.CommandLineArgsBuilder claBuilder, CommandLine cmd) throws ParseException {
        Level level;
        String connectString = cmd.hasOption(CliOption.CONNECT_STRING.getLongOpt()) ? CommandParser.getLatestOptionForArg(cmd, CliOption.CONNECT_STRING.getLongOpt()) : null;
        String username = null;
        char[] password = new char[]{};
        if (cmd.hasOption(CliOption.USERNAME.getLongOpt())) {
            username = CommandParser.getLatestOptionForArg(cmd, CliOption.USERNAME.getLongOpt());
            password = CommandParser.getPassword(username);
        }
        boolean quiet = cmd.hasOption(CliOption.QUIET.getLongOpt());
        ArrayList<String> pdbNames = cmd.hasOption(CliOption.PDBNAME.getLongOpt()) ? new ArrayList<String>(Arrays.asList(cmd.getOptionValues(CliOption.PDBNAME.getLongOpt()))) : Collections.emptyList();
        boolean sysdba = cmd.hasOption(CliOption.SYSDBA.getLongOpt());
        String outdir = cmd.hasOption(CliOption.OUTDIR.getLongOpt()) ? CommandParser.getLatestOptionForArg(cmd, CliOption.OUTDIR.getLongOpt()) : CommandParser.getDefaultOutputDirectory();
        String outFilePrefix = cmd.hasOption(CliOption.OUTFILEPREFIX.getLongOpt()) ? CommandParser.getLatestOptionForArg(cmd, CliOption.OUTFILEPREFIX.getLongOpt()) : null;
        String loggingLevel = cmd.hasOption(CliOption.LOGGINGLEVEL.getLongOpt()) ? CommandParser.getLatestOptionForArg(cmd, CliOption.LOGGINGLEVEL.getLongOpt()) : CliOption.LOGGINGLEVEL.getDefaultValue().name();
        try {
            level = Level.parse(loggingLevel.toUpperCase());
            Enum.valueOf(LoggingLevel.class, loggingLevel.toUpperCase());
        }
        catch (Exception e) {
            level = Level.FINE;
        }
        boolean zip = cmd.hasOption(CliOption.ZIP.getLongOpt());
        return claBuilder.username(username).password(password).connectString(connectString).quiet(quiet).genZipFile(zip).sysdba(sysdba).pdbNames(pdbNames).outdir(outdir).loggingLevel(level).outFilePrefix(outFilePrefix);
    }

    private static CommandLineArgs.CommandLineArgsBuilder buildSourceArgs(CommandLineArgs.CommandLineArgsBuilder claBuilder, CommandLine sourceCmd) throws ParseException {
        TargetCloud cloudType = !sourceCmd.hasOption(CliOption.TARGET_CLOUD.getLongOpt()) && sourceCmd.hasOption(CliOption.ANALYSISPROPS.getLongOpt()) ? null : CommandParser.toTargetCloudType(CommandParser.getLatestOptionForArg(sourceCmd, CliOption.TARGET_CLOUD.getLongOpt()));
        boolean forceFull = sourceCmd.hasOption(CliOption.FULL.getLongOpt());
        String[] schemasArray = sourceCmd.hasOption(CliOption.SCHEMAS.getLongOpt()) ? sourceCmd.getOptionValues(CliOption.SCHEMAS.getLongOpt()) : new String[]{};
        ArrayList<String> schemas = new ArrayList<String>(Arrays.asList(schemasArray));
        String[] excludeSchemasArray = sourceCmd.hasOption(CliOption.EXCLUDE_SCHEMAS.getLongOpt()) ? sourceCmd.getOptionValues(CliOption.EXCLUDE_SCHEMAS.getLongOpt()) : new String[]{};
        ArrayList<String> excludeSchemas = new ArrayList<String>(Arrays.asList(excludeSchemasArray));
        ArrayList<MigrationMethod> migrationMethods = new ArrayList<MigrationMethod>();
        if (sourceCmd.hasOption(CliOption.MIGRATION_METHOD.getLongOpt())) {
            for (String mmString : sourceCmd.getOptionValues(CliOption.MIGRATION_METHOD.getLongOpt())) {
                migrationMethods.add(CommandParser.toMigrationMethodType(mmString));
            }
        } else {
            migrationMethods.add((MigrationMethod)CliOption.MIGRATION_METHOD.getDefaultValue());
        }
        ArrayList<ReportFormat> reportFormats = new ArrayList<ReportFormat>();
        if (sourceCmd.hasOption(CliOption.REPORT_FORMAT.getLongOpt())) {
            for (String format : sourceCmd.getOptionValues(CliOption.REPORT_FORMAT.getLongOpt())) {
                ReportFormat reportFormat = CommandParser.toReportFormatType(format);
                if (reportFormats.contains(reportFormat)) continue;
                reportFormats.add(reportFormat);
            }
        } else {
            for (Enum defaultReportFormat : CliOption.REPORT_FORMAT.getDefaultValues()) {
                ReportFormat reportFormat = ReportFormat.valueOf(defaultReportFormat.name());
                reportFormats.add(reportFormat);
            }
        }
        String analysisPropsFile = sourceCmd.hasOption(CliOption.ANALYSISPROPS.getLongOpt()) ? CommandParser.getLatestOptionForArg(sourceCmd, CliOption.ANALYSISPROPS.getLongOpt()) : null;
        Integer maxTextRows = sourceCmd.hasOption(CliOption.MAXTEXTROWS.getLongOpt()) ? Integer.valueOf(CommandParser.getLatestOptionForArg(sourceCmd, CliOption.MAXTEXTROWS.getLongOpt())) : null;
        boolean textIncludeSql = sourceCmd.hasOption(CliOption.SQL_IN_TEXT_REPORT.getLongOpt());
        Integer maxRelevantObjects = sourceCmd.hasOption(CliOption.MAXRELEVANTOBJECTS.getLongOpt()) ? Integer.valueOf(CommandParser.getLatestOptionForArg(sourceCmd, CliOption.MAXRELEVANTOBJECTS.getLongOpt())) : null;
        ResultLevel resultLevel = sourceCmd.hasOption(CliOption.RESULT_LEVEL.getLongOpt()) ? CommandParser.toResultLevel(CommandParser.getLatestOptionForArg(sourceCmd, CliOption.RESULT_LEVEL.getLongOpt())) : (ResultLevel)CliOption.RESULT_LEVEL.getDefaultValue();
        boolean genFixups = sourceCmd.hasOption(CliOption.GENFIXUPS.getLongOpt());
        Integer maxSubprocesses = sourceCmd.hasOption(CliOption.MAXSUBPROCESSES.getLongOpt()) ? Integer.valueOf(sourceCmd.getOptionValue(CliOption.MAXSUBPROCESSES.getLongOpt())) : null;
        ArrayList<GatherDetailsOptions> gatherDetailsOptions = new ArrayList<GatherDetailsOptions>();
        if (sourceCmd.hasOption(CliOption.GATHERDETAILS.getLongOpt())) {
            String[] gatherDetailsValues;
            for (String detailToGather : gatherDetailsValues = sourceCmd.getOptionValues(CliOption.GATHERDETAILS.getLongOpt())) {
                GatherDetailsOptions gatherDetailsOption = CommandParser.toGatherDetailsOption(detailToGather);
                if (gatherDetailsOption == GatherDetailsOptions.NONE || gatherDetailsOption == GatherDetailsOptions.ALL) {
                    gatherDetailsOptions.clear();
                    gatherDetailsOptions.add(gatherDetailsOption);
                    continue;
                }
                if (gatherDetailsOptions.contains(GatherDetailsOptions.ALL) || gatherDetailsOptions.contains(GatherDetailsOptions.NONE) || gatherDetailsOptions.contains(gatherDetailsOption)) continue;
                gatherDetailsOptions.add(gatherDetailsOption);
            }
        } else {
            for (Enum defaultOptions : CliOption.GATHERDETAILS.getDefaultValues()) {
                GatherDetailsOptions gatherOption = GatherDetailsOptions.valueOf(defaultOptions.name());
                gatherDetailsOptions.add(gatherOption);
            }
        }
        String cpatKey = sourceCmd.hasOption(CliOption.CPATKEY.getLongOpt()) ? CommandParser.getLatestOptionForArg(sourceCmd, CliOption.CPATKEY.getLongOpt()) : null;
        return claBuilder.targetCloud(cloudType).forceFull(forceFull).schemas(schemas).excludeSchemas(excludeSchemas).migrationMethods(migrationMethods).reportFormats(reportFormats).analysisPropertiesFile(analysisPropsFile).maxTextRows(maxTextRows).sqlInTextReport(textIncludeSql).maxRelevantObjects(maxRelevantObjects).resultLevel(resultLevel).genFixups(genFixups).maxSubprocesses(maxSubprocesses).gatherDetailsOptions(gatherDetailsOptions).cpatKey(cpatKey);
    }

    private static CommandLineArgs.CommandLineArgsBuilder buildTargetArgs(CommandLineArgs.CommandLineArgsBuilder claBuilder, CommandLine targetCmd) throws ParseException {
        boolean fetchTargetProps = targetCmd.hasOption(CliOption.GETTARGETPROPS.getLongOpt());
        return claBuilder.fetchTargetProps(fetchTargetProps);
    }

    private static char[] getPassword(String username) {
        String prompt = lang.txt("PASSWORD_PROMPT_MSG", username);
        Console console = System.console();
        if (console != null) {
            return console.readPassword(prompt, new Object[0]);
        }
        System.out.print(prompt);
        Scanner sysInScanner = new Scanner(System.in);
        System.out.println();
        char[] password = sysInScanner.hasNext() ? sysInScanner.next().toCharArray() : "".toCharArray();
        return password;
    }

    public static String getDefaultOutputDirectory() {
        return System.getProperty("user.dir");
    }

    private static Option buildOption(CliOption cliOption) {
        Option.Builder builder = Option.builder((String)cliOption.getOpt()).longOpt(cliOption.getLongOpt()).desc(cliOption.getDescription()).required(cliOption.isRequired());
        switch (cliOption.getNumParams()) {
            case TAKES_NO_ARGS: {
                builder.hasArg(false);
                break;
            }
            case TAKES_ONE_ARG: {
                builder.hasArg(true);
                builder.argName(cliOption.getParamName());
                break;
            }
            case TAKES_ONE_OR_MORE_ARGS: {
                builder.hasArgs();
                builder.argName(cliOption.getParamName());
                break;
            }
            case TAKES_ZERO_OR_MORE_ARGS: {
                builder.optionalArg(true);
                builder.hasArgs();
                builder.argName(cliOption.getParamName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected cliOption.getNumParams()");
            }
        }
        return builder.build();
    }

    private OptionGroup createGroup(CliOption ... cliOptions) {
        OptionGroup optionGroup = new OptionGroup();
        for (CliOption cliOption : cliOptions) {
            Option option = CommandParser.buildOption(cliOption);
            optionGroup.addOption(option);
        }
        return optionGroup;
    }

    private void addOptions(Options options, CliOption ... cliOptions) {
        for (CliOption cliOption : cliOptions) {
            Option option = CommandParser.buildOption(cliOption);
            options.addOption(option);
        }
    }

    private static ReportFormat toReportFormatType(String reportFormatStr) throws ParseException {
        try {
            return ReportFormat.valueOf(reportFormatStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Report Format value: " + reportFormatStr);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    private static MigrationMethod toMigrationMethodType(String migrationMethodStr) throws ParseException {
        try {
            return MigrationMethod.valueOf(migrationMethodStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Migration Method value: " + migrationMethodStr);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    private static TargetCloud toTargetCloudType(String targetCloudStr) throws ParseException {
        try {
            return TargetCloud.valueOf(targetCloudStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Target Cloud value: " + targetCloudStr);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    private static ResultLevel toResultLevel(String resultLevelStr) throws ParseException {
        try {
            return ResultLevel.valueOf(resultLevelStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parserException = new ParseException("Not a valid Result Level value: " + resultLevelStr);
            parserException.initCause((Throwable)e);
            throw parserException;
        }
    }

    private static GatherDetailsOptions toGatherDetailsOption(String gatherOptionString) throws ParseException {
        try {
            return GatherDetailsOptions.valueOf(gatherOptionString.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Gather Details value: " + gatherOptionString);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    private static String getLatestOptionForArg(CommandLine sourceCmd, String cliOption) throws ParseException {
        String[] allValuesArg = sourceCmd.getOptionValues(cliOption);
        if (allValuesArg != null && allValuesArg[allValuesArg.length - 1] != null) {
            return allValuesArg[allValuesArg.length - 1];
        }
        throw new ParseException("Not a valid value for: " + cliOption);
    }

    public void printHelp(String premigrationSyntax, PrintWriter pw) {
        HelpFormatter formatter = new HelpFormatter();
        int helpWidth = CommandParser.getHelpWidth();
        formatter.printWrapped(pw, helpWidth, 1, lang.txt("CLI_HELP_PREAMBLE"));
        this.printHelpForMode(premigrationSyntax, pw, formatter, helpWidth, "CLI_HELP_SOURCE_MODE_PREAMBLE", "CLI_HELP_SOURCE_MODE_CLI_HEADER", this.visibleSourceOptions, "CLI_HELP_SOURCE_MODE_DESCRIPTION", "CLI_HELP_SOURCE_MODE_EXAMPLES", "CLI_HELP_SOURCE_MODE_USAGE_NOTES");
        this.printHelpForMode(premigrationSyntax, pw, formatter, helpWidth, "CLI_HELP_TARGET_MODE_PREAMBLE", "CLI_HELP_TARGET_MODE_CLI_HEADER", this.targetOptions, "CLI_HELP_TARGET_MODE_DESCRIPTION", "CLI_HELP_TARGET_MODE_EXAMPLES", "CLI_HELP_TARGET_MODE_USAGE_NOTES");
        this.printHelpForMode(premigrationSyntax, pw, formatter, helpWidth, "CLI_HELP_HELP_MODE_PREAMBLE", "CLI_HELP_HELP_MODE_CLI_HEADER", this.helpOptions, "CLI_HELP_HELP_MODE_EXAMPLES");
        this.printHelpForMode(premigrationSyntax, pw, formatter, helpWidth, "CLI_HELP_UPDATE_MODE_PREAMBLE", "CLI_HELP_UPDATE_MODE_CLI_HEADER", this.updateOptions, "CLI_HELP_UPDATE_MODE_DESCRIPTION", "CLI_HELP_UPDATE_MODE_EXAMPLES", "CLI_HELP_UPDATE_MODE_USAGE_NOTES");
        this.printHelpForMode(premigrationSyntax, pw, formatter, helpWidth, "CLI_HELP_CONFIGURATION_FILE_MODE_PREAMBLE", "CLI_HELP_CONFIGURATION_FILE_CLI_HEADER", this.configurationFileOptions, "CLI_HELP_CONFIGURATION_FILE_MODE_DESCRIPTION", "CLI_HELP_CONFIGURATION_FILE_MODE_EXAMPLES");
        formatter.printWrapped(pw, helpWidth, 3, lang.txt("CLI_HELP_JDBC_CONNECTSTRING_INFO"));
        pw.flush();
    }

    private void printHelpForMode(String premigrationSyntax, PrintWriter pw, HelpFormatter formatter, int helpWidth, String modePreambleKey, String modeCliHeader, Options cliOptions, String ... modePostKeys) {
        if (cliOptions.hasLongOption("gettargetprops")) {
            String[] desc = cliOptions.getOption("username").getDescription().split("\\.");
            cliOptions.getOption("username").setDescription(desc[0] + ".");
        }
        formatter.printWrapped(pw, helpWidth, lang.txt(modePreambleKey));
        pw.println();
        formatter.printHelp(pw, helpWidth, premigrationSyntax, lang.txt(modeCliHeader), cliOptions, 1, 3, null, true);
        for (String key : modePostKeys) {
            formatter.printWrapped(pw, helpWidth, 3, lang.txt(key));
        }
    }

    private static int getHelpWidth() {
        int terminalWidth = 74;
        String cpatTerminalWidth = System.getProperty("CPAT_TERMINAL_WIDTH", System.getenv("CPAT_TERMINAL_WIDTH"));
        if (cpatTerminalWidth != null && !cpatTerminalWidth.isEmpty()) {
            try {
                terminalWidth = Integer.parseInt(cpatTerminalWidth);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return terminalWidth;
    }
}

