/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.api;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.cli.CommandParser;
import com.oracle.premigration.cli.configuration.ConfigurationFile;
import com.oracle.premigration.cli.configuration.ConfigurationFileReader;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.io.OutputFilenamesContainer;
import com.oracle.premigration.commons.io.ZipContributor;
import com.oracle.premigration.commons.io.ZipFileHelper;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CDBSourceInspector;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.SourceInspector;
import com.oracle.premigration.dbinspector.TargetInspector;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleDriver;
import org.apache.commons.cli.ParseException;

public class Premigration {
    static final Language lang = Language.getInstance();

    private Premigration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(CommandLineArgs parsedCla, EnvironmentContext envCtx) {
        String logFilePath;
        block35: {
            int errorMessage2;
            block34: {
                CommandLineArgs cla;
                boolean isConfigurationFileUsed;
                long startPremigrationRun = System.currentTimeMillis();
                PremigrationLogger log = null;
                logFilePath = null;
                ExecutionContext exeCtx = null;
                boolean bl = isConfigurationFileUsed = parsedCla.getConfigurationFile() != null && !parsedCla.getConfigurationFile().isEmpty();
                if (isConfigurationFileUsed) {
                    String[] args;
                    try {
                        ConfigurationFileReader configurationFileReader = new ConfigurationFileReader(parsedCla.getConfigurationFile());
                        ConfigurationFile<String[]> configurationFile = configurationFileReader.getNoPrefixConfigurationFile();
                        args = configurationFile.getArguments();
                    }
                    catch (PremigrationException e) {
                        envCtx.getErrWriter().println(e.getMessage());
                        if (e.getCause() != null) {
                            envCtx.getErrWriter().println(e.getCause().getMessage());
                        }
                        return CheckResult.FATAL.getExitCode();
                    }
                    CommandParser commandParser = new CommandParser();
                    try {
                        CommandLineArgs commandLineFromFile = commandParser.parse(args);
                        cla = CommandLineArgs.applyDefaultValuesCommandLine(commandLineFromFile);
                    }
                    catch (ParseException e) {
                        String errorParsingConfigFile = Utilities.getErrorText("ERROR1023", parsedCla.getConfigurationFile());
                        envCtx.getErrWriter().println(errorParsingConfigFile);
                        envCtx.getErrWriter().println(e.getMessage());
                        return CheckResult.FATAL.getExitCode();
                    }
                }
                cla = CommandLineArgs.applyDefaultValuesCommandLine(parsedCla);
                boolean generateZip = cla.isGenZipFile();
                try {
                    if (cla.isVersion()) {
                        AppVersion.printVersionInfo(envCtx.getPrintStream());
                        int e = CheckResult.PASS.getExitCode();
                        return e;
                    }
                    if (cla.isSimpleVersion()) {
                        envCtx.getPrintStream().println(AppVersion.getVersionString());
                        int e = CheckResult.PASS.getExitCode();
                        return e;
                    }
                    if (cla.getCompareVersion() != null) {
                        int e = AppVersion.compareAppVersion(cla.getCompareVersion());
                        return e;
                    }
                    if (cla.isCheckForUpdates()) {
                        int e = AppVersion.checkForUpdates();
                        return e;
                    }
                    OutputFilenamesContainer outputFilenamesContainer = new OutputFilenamesContainer(cla.getOutFilePrefix(), cla.getOutdir());
                    logFilePath = outputFilenamesContainer.getValidatedLogFilePath();
                    PremigrationLogger.newConfig(logFilePath, cla.getLoggingLevel(), envCtx.getCommandInvocationMode());
                    log = PremigrationLogger.getLogger(Premigration.class.getName());
                    cla.validate(envCtx);
                    String appVersion = AppVersion.getVersionString();
                    String banner = lang.txt("APP_BANNER_MSG", appVersion);
                    log.info(banner);
                    log.info("Days since the jar was built: " + AppVersion.getAppAgeInDays());
                    Utilities.logEnvironmentVariables();
                    Utilities.logJavaProperties();
                    Utilities.logMemorySize(envCtx);
                    log.info("JDBC Driver Version: " + OracleDriver.getDriverVersion());
                    log.info(Utilities.getMaxAllowedKeyLengthInfo());
                    log.info("Effective command line: " + cla.getReconstitutedArgs());
                    if (isConfigurationFileUsed) {
                        log.info("Configuration File Used: " + parsedCla.getConfigurationFile());
                        String betaConfigurationFileMsg = Utilities.getErrorText("ERROR3006", new String[0]);
                        Utilities.printAndLogErrorMessage(betaConfigurationFileMsg, envCtx, Level.WARNING);
                    }
                    envCtx.getPrintStream().println(banner);
                    exeCtx = new ExecutionContext(cla, outputFilenamesContainer, envCtx);
                    if (exeCtx.isAnalysisOfMultiplePdbs()) {
                        log.shutdown();
                        outputFilenamesContainer = exeCtx.getOutputFilenamesContainer().renameFilesForCDBSummary();
                        logFilePath = outputFilenamesContainer.getValidatedLogFilePath();
                        PremigrationLogger.newConfig(logFilePath, cla.getLoggingLevel(), envCtx.getCommandInvocationMode(), true);
                        log = PremigrationLogger.getLogger(Premigration.class.getName());
                        exeCtx.setOutputFilenamesContainer(outputFilenamesContainer);
                    }
                    if (generateZip) {
                        String logFileName = outputFilenamesContainer.getLogOutputFilename();
                        ZipContributor logFileForZip = ZipFileHelper.createZipContributorForFile(logFileName, logFilePath);
                        exeCtx.getZipContents().add(logFileForZip);
                    }
                    if (cla.getMaxSubprocesses() != null && !exeCtx.isAnalysisOfMultiplePdbs()) {
                        String errorMessage2 = Utilities.getErrorText("ERROR1021", new String[0]);
                        Utilities.printAndLogErrorMessage(errorMessage2, envCtx, Level.INFO);
                        cla.setMaxSubprocesses(null);
                    }
                    CheckResult overallResult = cla.isFetchTargetProps() ? TargetInspector.fetchTargetProps(exeCtx, appVersion) : (exeCtx.isAnalysisOfMultiplePdbs() ? CDBSourceInspector.analyzeSourcePDBs(exeCtx, appVersion) : SourceInspector.analyzeSource(exeCtx, appVersion));
                    log.info("Elapsed time executing Premigration Advisor: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startPremigrationRun));
                    log.trace("Returning overall integer result to CLI: " + overallResult.getExitCode());
                    errorMessage2 = overallResult.getExitCode();
                    if (log != null) {
                        log.shutdown();
                    }
                    if (!generateZip) break block34;
                }
                catch (FileNotFoundException e) {
                    String FileErrorMsg = Utilities.getErrorText("ERROR3002", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, FileErrorMsg, e);
                    break block35;
                }
                catch (AccessDeniedException | IOException e) {
                    String ioErrorMsg = PremigrationLogger.isLoggerInitialized() ? Utilities.getErrorText("ERROR3000", e, new String[0]) : Utilities.getErrorTextNoAction("ERROR3000", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, ioErrorMsg, e);
                    break block35;
                }
                catch (SQLException e) {
                    String connectString = cla.getConnectString();
                    boolean isNotValidConnectionString = connectString == null || !connectString.contains("jdbc:oracle:thin:@") && !connectString.contains("jdbc:oracle:oci:@") && !connectString.contains("jdbc:oracle:oci8:@");
                    String sqlErrorMsg = isNotValidConnectionString ? Utilities.getErrorText("ERROR1014", e, new String[0]) : Utilities.getErrorText("ERROR1004", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, sqlErrorMsg, e);
                    break block35;
                }
                catch (Exception e) {
                    String fatalMsg = Utilities.getErrorText("ERROR1005", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, fatalMsg, e);
                    if (e instanceof ArithmeticException) {
                        String msg = lang.txt("APP_POSSIBLE_EXPIRED_ACCOUNT_MSG");
                        Utilities.printAndLogErrorMessage(msg, envCtx, Level.SEVERE);
                    }
                    break block35;
                }
                finally {
                    if (log != null) {
                        log.shutdown();
                    }
                    if (generateZip) {
                        ZipFileHelper.generateZipFile(exeCtx);
                    }
                }
                ZipFileHelper.generateZipFile(exeCtx);
            }
            return errorMessage2;
        }
        if (PremigrationLogger.isLoggerInitialized() && logFilePath != null) {
            envCtx.getErrWriter().println(lang.txt("APP_LOG_FILE_DETAILS_MSG", logFilePath));
        }
        return CheckResult.FATAL.getExitCode();
    }

    private static void commonErrorHandling(PremigrationLogger log, EnvironmentContext envCtx, String errorMsg, Throwable t) {
        envCtx.getErrWriter().println(errorMsg);
        if (log != null) {
            log.severe(errorMsg, t);
        }
    }
}

