/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.objectstorage.model.AccessTargetDetails;
import com.oracle.bmc.objectstorage.model.Fqdns;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PrivateEndpoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeModified")
    private final Date timeModified;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="privateEndpointIp")
    private final String privateEndpointIp;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="additionalPrefixes")
    private final List<String> additionalPrefixes;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="fqdns")
    private final Fqdns fqdns;
    @JsonProperty(value="etag")
    private final String etag;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="accessTargets")
    private final List<AccessTargetDetails> accessTargets;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="id")
    private final String id;

    @Deprecated
    @ConstructorProperties(value={"name", "namespace", "compartmentId", "createdBy", "timeCreated", "timeModified", "subnetId", "privateEndpointIp", "prefix", "additionalPrefixes", "nsgIds", "fqdns", "etag", "lifecycleState", "accessTargets", "freeformTags", "definedTags", "id"})
    public PrivateEndpoint(String name, String namespace, String compartmentId, String createdBy, Date timeCreated, Date timeModified, String subnetId, String privateEndpointIp, String prefix, List<String> additionalPrefixes, List<String> nsgIds, Fqdns fqdns, String etag, LifecycleState lifecycleState, List<AccessTargetDetails> accessTargets, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String id) {
        this.name = name;
        this.namespace = namespace;
        this.compartmentId = compartmentId;
        this.createdBy = createdBy;
        this.timeCreated = timeCreated;
        this.timeModified = timeModified;
        this.subnetId = subnetId;
        this.privateEndpointIp = privateEndpointIp;
        this.prefix = prefix;
        this.additionalPrefixes = additionalPrefixes;
        this.nsgIds = nsgIds;
        this.fqdns = fqdns;
        this.etag = etag;
        this.lifecycleState = lifecycleState;
        this.accessTargets = accessTargets;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.id = id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeModified() {
        return this.timeModified;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getPrivateEndpointIp() {
        return this.privateEndpointIp;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<String> getAdditionalPrefixes() {
        return this.additionalPrefixes;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public Fqdns getFqdns() {
        return this.fqdns;
    }

    public String getEtag() {
        return this.etag;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<AccessTargetDetails> getAccessTargets() {
        return this.accessTargets;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PrivateEndpoint(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeModified=").append(String.valueOf(this.timeModified));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", privateEndpointIp=").append(String.valueOf(this.privateEndpointIp));
        sb.append(", prefix=").append(String.valueOf(this.prefix));
        sb.append(", additionalPrefixes=").append(String.valueOf(this.additionalPrefixes));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", fqdns=").append(String.valueOf((Object)this.fqdns));
        sb.append(", etag=").append(String.valueOf(this.etag));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", accessTargets=").append(String.valueOf(this.accessTargets));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrivateEndpoint)) {
            return false;
        }
        PrivateEndpoint other = (PrivateEndpoint)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeModified, other.timeModified) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.privateEndpointIp, other.privateEndpointIp) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.additionalPrefixes, other.additionalPrefixes) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals((Object)this.fqdns, (Object)other.fqdns) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.accessTargets, other.accessTargets) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.id, other.id) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeModified == null ? 43 : this.timeModified.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.privateEndpointIp == null ? 43 : this.privateEndpointIp.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.additionalPrefixes == null ? 43 : this.additionalPrefixes.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.fqdns == null ? 43 : this.fqdns.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.accessTargets == null ? 43 : this.accessTargets.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeModified")
        private Date timeModified;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="privateEndpointIp")
        private String privateEndpointIp;
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonProperty(value="additionalPrefixes")
        private List<String> additionalPrefixes;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="fqdns")
        private Fqdns fqdns;
        @JsonProperty(value="etag")
        private String etag;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="accessTargets")
        private List<AccessTargetDetails> accessTargets;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="id")
        private String id;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeModified(Date timeModified) {
            this.timeModified = timeModified;
            this.__explicitlySet__.add("timeModified");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder privateEndpointIp(String privateEndpointIp) {
            this.privateEndpointIp = privateEndpointIp;
            this.__explicitlySet__.add("privateEndpointIp");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public Builder additionalPrefixes(List<String> additionalPrefixes) {
            this.additionalPrefixes = additionalPrefixes;
            this.__explicitlySet__.add("additionalPrefixes");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder fqdns(Fqdns fqdns) {
            this.fqdns = fqdns;
            this.__explicitlySet__.add("fqdns");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            this.__explicitlySet__.add("etag");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder accessTargets(List<AccessTargetDetails> accessTargets) {
            this.accessTargets = accessTargets;
            this.__explicitlySet__.add("accessTargets");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public PrivateEndpoint build() {
            PrivateEndpoint model = new PrivateEndpoint(this.name, this.namespace, this.compartmentId, this.createdBy, this.timeCreated, this.timeModified, this.subnetId, this.privateEndpointIp, this.prefix, this.additionalPrefixes, this.nsgIds, this.fqdns, this.etag, this.lifecycleState, this.accessTargets, this.freeformTags, this.definedTags, this.id);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PrivateEndpoint model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeModified")) {
                this.timeModified(model.getTimeModified());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointIp")) {
                this.privateEndpointIp(model.getPrivateEndpointIp());
            }
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            if (model.wasPropertyExplicitlySet("additionalPrefixes")) {
                this.additionalPrefixes(model.getAdditionalPrefixes());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("fqdns")) {
                this.fqdns(model.getFqdns());
            }
            if (model.wasPropertyExplicitlySet("etag")) {
                this.etag(model.getEtag());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("accessTargets")) {
                this.accessTargets(model.getAccessTargets());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            return this;
        }
    }
}

