/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import oracle.dbtools.sdks.installer.utils.MavenCoordinates;

public class DependencySet {
    private final Map<String, MavenCoordinates> dependencies;

    private DependencySet(Builder builder) {
        this.dependencies = new LinkedHashMap<String, MavenCoordinates>(builder.dependencies);
    }

    private static boolean isJar(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar");
    }

    public static DependencySet of(Path root) {
        Builder dependencies = DependencySet.builder();
        if (Files.exists(root, new LinkOption[0]) && Files.isDirectory(root, new LinkOption[0])) {
            try (Stream<Path> children = Files.walk(root, new FileVisitOption[0]).filter(DependencySet::isJar);){
                children.forEach(dependencies::dependency);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return dependencies.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int size() {
        return this.dependencies.size();
    }

    public MavenCoordinates dependency(String artifactId) {
        return this.dependencies.get(artifactId);
    }

    public static final class Builder {
        private final Map<String, MavenCoordinates> dependencies = new LinkedHashMap<String, MavenCoordinates>();

        private Builder() {
        }

        public Builder dependency(MavenCoordinates dependency) {
            this.dependencies.putIfAbsent(dependency.artifactId(), dependency);
            return this;
        }

        public Builder dependency(Path dependency) {
            try {
                MavenCoordinates coordinates = MavenCoordinates.of(dependency);
                this.dependencies.putIfAbsent(coordinates.artifactId(), coordinates);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this;
        }

        public DependencySet build() {
            return new DependencySet(this);
        }
    }
}

