/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.downloader;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import oracle.dbtools.sdks.installer.utils.DependencySet;
import oracle.dbtools.sdks.installer.utils.MavenCoordinates;

class InstalledDependencies {
    private static final Path TARGET = Path.of("sqlcl-app-distribution", "target");
    private static final InstalledDependencies INSTANCE = new InstalledDependencies(InstalledDependencies.libFolder());
    private final DependencySet dependencySet;

    private InstalledDependencies(Path root) {
        this.dependencySet = DependencySet.of(root);
    }

    static InstalledDependencies instance() {
        return INSTANCE;
    }

    private static boolean isDistribution(Path path) {
        Path lib = path.resolve("sqlcl").resolve("lib");
        return Files.isDirectory(path, new LinkOption[0]) && Files.exists(lib, new LinkOption[0]);
    }

    private static Path findDistribution(Path path) throws IOException {
        try (Stream<Path> children = Files.walk(path, new FileVisitOption[0]).filter(InstalledDependencies::isDistribution);){
            Path path2 = children.findFirst().orElseThrow(() -> new IllegalStateException("No product distribution found in: " + String.valueOf(path) + ". Ensure a full Maven build has been done"));
            return path2;
        }
    }

    private static Path libFolder() {
        try {
            URI codeLocation = InstalledDependencies.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path codePath = Path.of(codeLocation);
            if (Files.isDirectory(codePath, new LinkOption[0])) {
                Path projectRoot = codePath.getParent().getParent().getParent().getParent();
                Path distributionTarget = projectRoot.resolve(TARGET);
                return InstalledDependencies.findDistribution(distributionTarget);
            }
            Path lib = codePath.getParent().getParent();
            return lib;
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    MavenCoordinates dependency(String artifactId) {
        return this.dependencySet.dependency(artifactId);
    }
}

