/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.utility;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.exceptions.ApexQueryException;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.jdbc.OracleCallableStatement;

public class QueryUtils {
    public static String _version = "";
    static QueryXMLSupport s_xml = null;

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(QueryUtils.class.getClassLoader(), "oracle/dbtools/extension/apex/xml/ApexCommandQueries.xml"));
        }
        return s_xml;
    }

    public static void loadAppDetail(Connection conn, MutableCommand command, BigDecimal appId) throws SQLException, InvalidApexExportException {
        if (appId == null) {
            throw new InvalidApexExportException();
        }
        PreparedStatement stmt = conn.prepareStatement(QueryUtils.getXMLQueries().getQuery("getAppDetails", conn).getSql());
        stmt.setBigDecimal(1, appId);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            command.setOptionValue(ApexOptions.Symbol.WORKSPACEID, result.getBigDecimal(1));
            if (command.getOptionValue(ApexOptions.Symbol.WORKSPACENAME) == null || command.getOptionValue(ApexOptions.Symbol.WORKSPACENAME).toString().length() <= 0) {
                command.setOptionValue(ApexOptions.Symbol.WORKSPACENAME, result.getString(2));
            }
            command.setOptionValue(ApexOptions.Symbol.APPLICATIONNAME, result.getString(3));
        }
        result.close();
        stmt.close();
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        String cleanversion;
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException();
        }
        _version = cleanversion = version.replaceAll("-", "");
        Version source = new Version(cleanversion);
        return source.compareTo(new Version("19.2")) > 0;
    }

    public static String getAPEXApiVersion(Connection conn) {
        String apiVersion = DBUtil.getInstance((Connection)conn).executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.api.version", conn).getSql());
        return apiVersion;
    }

    public static BigDecimal getId(Connection conn, String report) throws SQLException {
        String p_stmt = QueryUtils.getXMLQueries().getQuery(report, conn).getSql();
        OracleCallableStatement l_stmt = (OracleCallableStatement)conn.prepareCall(p_stmt);
        l_stmt.registerOutParameter(1, 2, "RESULT");
        l_stmt.execute();
        String result = l_stmt.getObject(1).toString();
        l_stmt.close();
        return new BigDecimal(result);
    }

    public static BigDecimal generateApplicationId(Connection conn) throws ApexQueryException, SQLException {
        String report = "apex.command.generate_application_id";
        BigDecimal applicationId = QueryUtils.getId(conn, "apex.command.generate_application_id");
        if (null == applicationId) {
            throw new ApexQueryException(ApexMessages.getString("GENERATE_APP_ID_ERROR"));
        }
        return applicationId;
    }

    public static BigDecimal generateOffset(Connection conn) throws ApexQueryException, SQLException {
        String report = "apex.command.generate_offset";
        BigDecimal offset = QueryUtils.getId(conn, "apex.command.generate_offset");
        if (null == offset) {
            throw new ApexQueryException(ApexMessages.getString("GENERATE_OFFSET_ERROR"));
        }
        return offset;
    }

    public static String getSchema(Connection conn) {
        String schema = DBUtil.getInstance((Connection)conn).executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.command.get_schema", conn).getSql());
        return schema;
    }

    public static BigDecimal getWorkspaceId(Connection conn) throws ApexQueryException, SQLException {
        String report = "apex.command.get_workspace_id";
        ArrayList<BigDecimal> workspaceIds = new ArrayList<BigDecimal>();
        try (PreparedStatement stmt = conn.prepareStatement(QueryUtils.getXMLQueries().getQuery("apex.command.get_workspace_id", conn).getSql());
             ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                workspaceIds.add(result.getBigDecimal(1));
            }
        }
        if (workspaceIds.size() > 1) {
            throw new ApexQueryException(ApexMessages.getString("MULTIPLE_WORKSPACES"));
        }
        if (workspaceIds.size() == 1) {
            return (BigDecimal)workspaceIds.get(0);
        }
        throw new ApexQueryException(ApexMessages.getString("WORKSPACE_NOT_FOUND"));
    }
}

