/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.FileLoader;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.metametadata.Metametadata;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.APEXLangUtils;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;

public class APEXLangTranspiler {
    private final APEXLangCompiler compiler = new APEXLangCompiler();

    public APEXLangCompilationResult transpile(Path inputPath) throws InvalidParameterException, IOException {
        APEXLangManifestObject manifest = null;
        return this.transpile(inputPath, manifest);
    }

    public APEXLangCompilationResult transpile(Path inputPath, Path manifestFilePath) throws InvalidParameterException, IOException {
        if (APEXLangUtils.isAPEXLangFile(inputPath) && manifestFilePath == null) {
            throw new InvalidParameterException(ApexMessages.getString("MANIFEST_FILE_PATH_ERROR"));
        }
        if (manifestFilePath != null && Files.notExists(manifestFilePath, new LinkOption[0])) {
            throw new IOException(ApexMessages.format("MANIFEST_FILE_NOT_FOUND_ERROR", manifestFilePath));
        }
        return this.transpile(inputPath, (APEXLangManifestObject)JSON.std.beanFrom(APEXLangManifestObject.class, (Object)Files.readString(manifestFilePath)));
    }

    public APEXLangCompilationResult transpile(Path inputPath, APEXLangManifestObject manifest) throws InvalidParameterException, IOException {
        HashMap<String, String> srcFiles;
        if (inputPath == null) {
            throw new InvalidParameterException(ApexMessages.getString("INPUT_NULL_ERROR"));
        }
        if (Files.notExists(inputPath, new LinkOption[0])) {
            throw new IOException(ApexMessages.format("INPUT_NOT_FOUND_ERROR", inputPath));
        }
        if (APEXLangUtils.isAPEXLangFile(inputPath) && manifest == null) {
            throw new InvalidParameterException(ApexMessages.getString("MANIFEST_FILE_ERROR"));
        }
        FileLoader fileLoader = new FileLoader();
        if (APEXLangUtils.isDirectoryOrZip(inputPath)) {
            srcFiles = fileLoader.loadAPEXLangSourceFiles(inputPath.toString());
        } else if (APEXLangUtils.isAPEXLangFile(inputPath)) {
            srcFiles = new HashMap<String, String>();
            srcFiles.put(inputPath.toString(), Files.readString(inputPath));
            srcFiles.put(APEXLangCompiler.MANIFEST_FILENAME, JSON.std.asString((Object)manifest));
        } else {
            throw new InvalidParameterException(ApexMessages.getString("INPUT_TYPE_ERROR"));
        }
        return this.transpile(srcFiles, new APEXLangCompilerContext());
    }

    APEXLangCompilationResult transpile(Map<String, String> fileMap, APEXLangCompilerContext appState) {
        return this.compiler.compile(fileMap, appState);
    }

    APEXLangCompiler getCompiler() {
        return this.compiler;
    }

    Metametadata getMetaMetaData() {
        return this.compiler.getMetametadata();
    }

    public String formatErrors(APEXLangSyntaxError[] errors) {
        Object str = ApexMessages.getString("COMPILE_ERROR");
        for (APEXLangSyntaxError error : errors) {
            str = (String)str + ApexMessages.format("COMPILE_LINE_ERROR", error.getFilename(), error.getLine(), error.getColumn(), error.getMsg());
        }
        return str;
    }
}

