/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangApplicationState;

public class APEXLangApplicationStateContext {
    private final Map<URI, APEXLangApplicationState> cache;
    private final AtomicReference<State> state = new AtomicReference<State>(State.SHUTDOWN);

    private APEXLangApplicationStateContext(Builder builder) {
        this.cache = new ConcurrentHashMap<URI, APEXLangApplicationState>();
    }

    public void activate() {
        this.state.compareAndSet(State.SHUTDOWN, State.ACTIVE);
    }

    public void shutdown() {
        this.state.getAndUpdate(state1 -> {
            if (state1 == State.ACTIVE) {
                this.cache.clear();
                return State.SHUTDOWN;
            }
            throw new ConcurrentModificationException();
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public APEXLangApplicationState getApplicationState(URI uri) {
        Path rootPath = null;
        Path configPath = null;
        if (uri != null) {
            Path path = Path.of(uri.getPath(), new String[0]);
            Path previous = null;
            Path parent = path.getParent();
            while (parent != null) {
                Path cfgPath2 = parent.resolve("config.json");
                if (cfgPath2.toFile().exists()) {
                    rootPath = parent;
                    configPath = cfgPath2;
                    break;
                }
                List listing = null;
                try {
                    listing = Files.list(parent).collect(Collectors.toUnmodifiableList());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                boolean anyApx = false;
                for (Path path2 : listing) {
                    if (path2.endsWith("application.apx") || path2.endsWith("pages") || path2.endsWith("shared_components") || path2.endsWith("supporting_objects")) {
                        rootPath = parent;
                        break;
                    }
                    if (!path2.toString().endsWith(".apx")) continue;
                    anyApx = true;
                }
                if (!anyApx) {
                    rootPath = previous;
                    break;
                }
                previous = parent;
                parent = previous.getParent();
            }
        }
        Path configPathFinal = configPath;
        Path rootPathFinal = rootPath;
        if (rootPathFinal == null) {
            return null;
        }
        return this.cache.computeIfAbsent(rootPathFinal.toUri(), rp -> {
            String configContent = null;
            APEXLangManifestObject manifestObject = null;
            if (configPathFinal != null) {
                try {
                    configContent = Files.readString(configPathFinal, Charset.defaultCharset());
                    manifestObject = (APEXLangManifestObject)JSON.std.beanFrom(APEXLangManifestObject.class, (Object)configContent);
                }
                catch (IOException e) {
                    configContent = null;
                }
            }
            return new APEXLangApplicationState(rootPathFinal, configContent, manifestObject);
        });
    }

    private static enum State {
        ACTIVE,
        SHUTDOWN;

    }

    public static class Builder {
        public APEXLangApplicationStateContext build() {
            return new APEXLangApplicationStateContext(this);
        }
    }
}

