/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.FileLoader;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.Location;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Property;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangTranspiler;

public class APEXLangApplicationState {
    private final Path rootPath;
    private final String configContent;
    private final APEXLangManifestObject manifestObject;
    private BigDecimal applicationId;
    private final APEXLangTranspiler apexLangTranspiler;
    private final APEXLangCompilerContext apexLangCompilerContext;

    APEXLangApplicationState(Path rootPath, String configContent, APEXLangManifestObject manifestObject) {
        this.rootPath = rootPath;
        this.configContent = configContent;
        this.manifestObject = manifestObject;
        this.apexLangTranspiler = new APEXLangTranspiler();
        this.apexLangCompilerContext = rootPath != null ? this.apexLangTranspiler.getCompiler().getCompilerContext(this.getApplicationFileMap(null)) : new APEXLangCompilerContext();
        this.applicationId = manifestObject != null && manifestObject.getApi_version() != null ? new BigDecimal(manifestObject.getApp_id()) : null;
    }

    Map<String, String> getApplicationFileMap(Map<URI, String> openFiles) {
        FileLoader fileLoader = new FileLoader();
        HashMap<String, String> fileMap = new HashMap();
        try {
            fileMap = fileLoader.getFilesFromDirectory(this.rootPath.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashMap<String, String> finalMap = fileMap;
        if (openFiles != null) {
            openFiles.forEach((uri, source) -> {
                String key = this.rootPath.relativize(Path.of(uri)).toString();
                finalMap.put(key, (String)source);
            });
        }
        return fileMap;
    }

    public APEXLangCompilationResult compileApplication(Map<URI, String> openFiles) {
        return this.apexLangTranspiler.transpile(this.getApplicationFileMap(openFiles), new APEXLangCompilerContext());
    }

    public APEXLangCompilationResult compile(URI uri, String source, System.Logger logger) {
        APEXLangCompilationResult result;
        block3: {
            String relativePath = this.getRelativeFilePath(uri.getPath());
            HashMap<String, String> fileMap = new HashMap<String, String>();
            fileMap.put(relativePath, source);
            if (this.configContent != null) {
                fileMap.put(APEXLangCompiler.MANIFEST_FILENAME, this.configContent);
            }
            try {
                result = this.apexLangTranspiler.transpile(fileMap, this.apexLangCompilerContext);
            }
            catch (Exception e) {
                result = new APEXLangCompilationResult("", new APEXLangSyntaxError[0], (Collection)Collections.EMPTY_LIST);
                if (logger == null) break block3;
                logger.log(System.Logger.Level.ERROR, e);
            }
        }
        return result;
    }

    private String getRelativeFilePath(String uri) {
        String path = URI.create(uri).getPath();
        if (this.rootPath != null) {
            return this.rootPath.relativize(Path.of(path, new String[0])).toString();
        }
        return path;
    }

    public URI getUri(String relativeFilePath) {
        if (this.rootPath != null) {
            return this.rootPath.resolve(relativeFilePath).toUri();
        }
        return null;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public List<String> getAvailableReferences(Property property, ComponentParameter componentParameter) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(componentParameter);
        return this.apexLangTranspiler.getCompiler().getAvailableReferences(property, componentParameter, this.apexLangCompilerContext);
    }

    public Location getReferenceLocation(Property property, ComponentParameter componentParameter) {
        if (property != null && componentParameter != null) {
            Location loc;
            Object reference = componentParameter.getValue();
            if (reference != null && !((String)reference).startsWith("@")) {
                reference = "@" + (String)reference;
            }
            if ((loc = this.apexLangTranspiler.getCompiler().getReferenceLocation(property, componentParameter, this.apexLangCompilerContext, (String)reference)) != null) {
                return new Location(this.getUri(loc.getFilePath()).toString(), loc.getPostion());
            }
        }
        return null;
    }

    public List<ComponentType> getAvailableChildComponentTypes(Component component) {
        Metametadata mmd = this.getMetaMetaData();
        ArrayList<ComponentType> ret = new ArrayList<ComponentType>();
        String parentComponentTypeId = component.getTypeId();
        if (parentComponentTypeId != null) {
            for (Map.Entry entry : mmd.getComponentTypes().entrySet()) {
                ComponentType componentType = (ComponentType)entry.getValue();
                ComponentType.Parent parent = componentType.getParent();
                if (parent == null || !parentComponentTypeId.equals(parent.getComponentTypeId())) continue;
                ret.add(componentType);
            }
        }
        return ret;
    }

    public List<Property> getAvailableProperties(Component component) {
        Metametadata mmd = this.getMetaMetaData();
        Set setPropIds = component.getParameters().keySet();
        ComponentType componentType = (ComponentType)mmd.getComponentTypes().get(component.getTypeId());
        Set availablePropIds = componentType.getProperties().keySet();
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Map.Entry entry : mmd.getProperties().entrySet()) {
            if (!availablePropIds.contains(entry.getKey()) || setPropIds.contains(entry.getKey())) continue;
            ret.add((Property)entry.getValue());
        }
        return ret;
    }

    public BigDecimal getApplicationId() {
        return this.applicationId;
    }

    public Metametadata getMetaMetaData() {
        return this.apexLangTranspiler.getMetaMetaData();
    }
}

