/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.extension.apex.utility.QueryUtils;

public class APEXApplicationInstallOverrides {
    private final BigDecimal workspaceId;
    private final BigDecimal applicationId;
    private final BigDecimal offset;
    private final String schema;
    private final String name;
    private final String alias;
    private final String imagePrefix;
    private final String proxy;
    private Map<String, Object> overrideMap;

    public Map<String, Object> getOverrideMap() {
        if (this.overrideMap != null) {
            return this.overrideMap;
        }
        this.overrideMap = new HashMap<String, Object>();
        if (this.workspaceId != null) {
            this.overrideMap.put("workspace_id", this.workspaceId);
        }
        if (this.applicationId != null) {
            this.overrideMap.put("application_id", this.applicationId);
        }
        if (this.offset != null) {
            this.overrideMap.put("offset", this.offset);
        }
        if (this.schema != null) {
            this.overrideMap.put("schema", this.schema);
        }
        if (this.name != null) {
            this.overrideMap.put("name", this.name);
        }
        if (this.alias != null) {
            this.overrideMap.put("alias", this.alias);
        }
        if (this.imagePrefix != null) {
            this.overrideMap.put("image_prefix", this.imagePrefix);
        }
        if (this.proxy != null) {
            this.overrideMap.put("proxy", this.proxy);
        }
        return this.overrideMap;
    }

    public String generateOverridePLSQL(Connection conn) {
        Object plsql = "";
        for (Map.Entry<String, Object> entry : this.getOverrideMap().entrySet()) {
            if (entry.getValue() == null) continue;
            plsql = (String)plsql + QueryUtils.getXMLQueries().getQuery("apex.command.set_import_" + String.valueOf(entry.getKey()), conn).getSql() + "\n/\n";
        }
        return plsql;
    }

    private APEXApplicationInstallOverrides(Builder builder) {
        this.workspaceId = builder.workspaceId;
        this.applicationId = builder.applicationId;
        this.offset = builder.offset;
        this.schema = builder.schema;
        this.name = builder.name;
        this.alias = builder.alias;
        this.imagePrefix = builder.imagePrefix;
        this.proxy = builder.proxy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BigDecimal workspaceId;
        private BigDecimal applicationId;
        private BigDecimal offset;
        private String schema;
        private String name;
        private String alias;
        private String imagePrefix;
        private String proxy;

        public APEXApplicationInstallOverrides build() {
            return new APEXApplicationInstallOverrides(this);
        }

        public Builder workspaceId(BigDecimal workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationId(BigDecimal applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder offset(BigDecimal offset) {
            this.offset = offset;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder imagePrefix(String imagePrefix) {
            this.imagePrefix = imagePrefix;
            return this;
        }

        public Builder proxy(String proxy) {
            this.proxy = proxy;
            return this;
        }
    }
}

