/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import java.util.Arrays;

public class modified_db_parameters_serverless
extends Check {
    private static final String SQL_QUERY = "SELECT name from V$PARAMETER  WHERE (isdefault = 'FALSE' or ismodified != 'FALSE')   AND isbasic = 'FALSE' AND LOWER(name) NOT IN ( '_file_size_increase_increment', '_enable_numa_support', 'approx_for_aggregation',  'approx_for_count_distinct',  'approx_for_percentile',  'audit_file_dest',  'audit_trail',  'client_prefetch_rows ',  'constraints',  'container',  'container_data',  'current_schema',  'cursor_invalidation',  'cursor_sharing',  'ddl_lock_timeout',  'default_collation',  'default_credential',  'diagnostic_dest',  'dispatchers',  'edition',  'fixed_date',  'ignore_session_set_param_errors',  'isolation_level',  'job_queue_processes',  'ldap_directory_access',  'load_without_compile ',  'max_idle_time',  'max_string_size',  'nls_calendar',  'nls_comp',  'nls_currency',  'nls_date_format',  'nls_date_language',  'nls_dual_currency',  'nls_iso_currency',  'nls_language',  'nls_length_semantics',  'nls_nchar_conv_excp',  'nls_numeric_characters',  'nls_sort',  'nls_territory',  'nls_time_format',  'nls_time_tz_format',  'nls_timestamp_format',  'nls_timestamp_tz_format',  'optimizer_capture_sql_quarantine',  'optimizer_ignore_hints',  'optimizer_ignore_parallel_hints',  'optimizer_mode',  'optimizer_real_time_statistics',  'optimizer_use_sql_quarantine',  'plscope_settings',  'plsql_ccflags',  'plsql_debug',  'plsql_optimize_level',  'plsql_warnings',  'query_rewrite_integrity',  'read_only',  'recycle_bin ',  'remote_dependencies_mode',  'result_cache_integrity',  'result_cache_mode',  'session_exit_on_package_state_error',  'skip_unusable_inedexes',  'sql_translation_profile',  'statistics_level',  'sysdate_at_dbtimezone',  'timezone' ) AND LOWER(name) NOT IN (SELECT LOWER(parameter) FROM nls_session_parameters) ORDER BY name";

    public modified_db_parameters_serverless() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.OTHER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery(SQL_QUERY);
    }
}

