/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.gg_not_unique;
import com.oracle.premigration.helpers.SqlUtils;

public class gg_not_unique_bad_col_yes
extends gg_not_unique {
    public gg_not_unique_bad_col_yes() {
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasGGNotUnique = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_GOLDENGATE_NOT_UNIQUE").build());
        if (!hasGGNotUnique) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "DBA_GOLDENGATE_NOT_UNIQUE", "TABLE"), CheckResult.WARNING);
            return;
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, TABLE_NAME, BAD_COLUMN  FROM SYS.DBA_GOLDENGATE_NOT_UNIQUE " + whereClause + " AND BAD_COLUMN = 'Y'  ORDER BY 1, 2";
        this.setSqlQuery(sqlQuery);
    }
}

