/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class gg_has_low_streams_pool_size
extends Check
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(gg_has_low_streams_pool_size.class.getName());
    protected static final long MIN_STREAMS_POOL_SIZE = 0x4F000000L;
    private static final List<String> PARAMS = Collections.singletonList("streams_pool_size");

    public gg_has_low_streams_pool_size() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Collections.singletonList(MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT LOWER(NAME) AS NAME,CAST(VALUE AS VARCHAR2(100)) AS VALUE FROM V$PARAMETER " + SqlUtils.createWhereInClause("LOWER(NAME)", PARAMS));
    }

    @Override
    public CheckResult determineResult() {
        if (this.getRelevantObjectsData() == null || this.getRelevantObjectsData().size() != PARAMS.size()) {
            this.processInvalidValue("Database Parameters");
            return CheckResult.FATAL;
        }
        long streamsPoolSize = 0L;
        for (int i = 0; i < PARAMS.size(); ++i) {
            long numValue;
            String key = this.getRelevantObjectsData().get(i).get("NAME");
            String strValue = this.getRelevantObjectsData().get(i).get("VALUE");
            try {
                numValue = Utilities.stringToLong(strValue);
            }
            catch (Exception e) {
                this.processInvalidValue(key, e);
                return CheckResult.FATAL;
            }
            if (!key.equals("streams_pool_size")) {
                throw new IllegalArgumentException("Unexpected key: " + key);
            }
            streamsPoolSize = numValue;
        }
        log.trace("using " + streamsPoolSize + " as " + "streams_pool_size");
        if (streamsPoolSize < 0x4F000000L) {
            return CheckResult.WARNING;
        }
        return CheckResult.PASS;
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "gg_set_streams_pool_size";
        Fixup.Locus locus = Fixup.Locus.source;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("gg_set_streams_pool_size", locus, parentFolderPath).runAtCDBLevel(exeCtx.isDatabaseIsCDB()).restartRequired(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

