/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.CloudService;
import com.oracle.premigration.dbinspector.addinform.InstalledPackage;
import com.oracle.premigration.dbinspector.addinform.PackagesList;
import com.oracle.premigration.dbinspector.addinform.RedoData;
import com.oracle.premigration.dbinspector.addinform.VendorsList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InfoCollector {
    private InfoCollector() {
    }

    public static CloudService detectCloudVendor(ExecutionContext exeCtx) throws SQLException {
        List<CloudService> cloudServices = VendorsList.createVendorsList();
        for (CloudService cloudService : cloudServices) {
            cloudService.prepare();
            if (!cloudService.determineResult(exeCtx)) continue;
            return cloudService;
        }
        return null;
    }

    public static List<InstalledPackage> detectPackageInstalled(ExecutionContext exeCtx) throws SQLException {
        List<InstalledPackage> installedPackageList = PackagesList.createInstalledPackageList();
        ArrayList<InstalledPackage> installedPackageInTheSource = new ArrayList<InstalledPackage>();
        for (InstalledPackage installedPackage : installedPackageList) {
            installedPackage.prepare();
            if (!installedPackage.determineIfPackageIsInstalled(exeCtx)) continue;
            installedPackageInTheSource.add(installedPackage);
        }
        return installedPackageInTheSource.isEmpty() ? null : installedPackageInTheSource;
    }

    public static RedoData getRedoData(ExecutionContext exeCtx) {
        return RedoData.getRedoData(exeCtx);
    }
}

