/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.commands.pushd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Deque;
import java.util.Optional;
import java.util.function.BiConsumer;
import oracle.dbtools.extension.pushdpopddirs.commands.Messages;
import oracle.dbtools.extension.pushdpopddirs.commands.pushd.PushdCommand;
import oracle.dbtools.extension.pushdpopddirs.service.DirectoryManager;
import oracle.dbtools.extension.pushdpopddirs.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;

public class DirectoryAction
implements BiConsumer<ScriptRunnerContext, ParsedCommand> {
    private final String parameter;

    public DirectoryAction(Node node, TransformContext context, Environment environment) {
        this.parameter = (String)node.getValue();
    }

    @Override
    public void accept(ScriptRunnerContext ctx, ParsedCommand parsedCmd) {
        DirectoryManager directoryManager = (DirectoryManager)ctx.getService(DirectoryManager.class);
        if (this.isSpecialSymbolPath(this.parameter)) {
            this.handleSpecialSymbolPath(directoryManager, ctx, this.parameter);
        } else {
            String directoryPath = this.parameter;
            boolean isNFlagSet = parsedCmd.isFlagSet((Id)PushdCommand.Symbol.N);
            if (this.isDirectoriesEmpty(directoryManager)) {
                String pwd = this.getPwd(ctx);
                directoryManager.pushDirectory(pwd);
            }
            if (isNFlagSet) {
                try {
                    Optional<Path> path = FileUtils.validatePath(ctx, directoryPath);
                    path.ifPresent(p -> directoryManager.pushInSecondPosition(p.toString()));
                    directoryManager.printDirectories(ctx, directoryManager.getDirectories());
                }
                catch (IOException e) {
                    ctx.writeln(e.getMessage());
                }
            } else {
                this.handleRegularDirectory(directoryManager, ctx, directoryPath);
            }
        }
    }

    public boolean isSpecialSymbolPath(String directoryPath) {
        return directoryPath.startsWith("+") || directoryPath.startsWith("_");
    }

    private void handleSpecialSymbolPath(DirectoryManager directoryManager, ScriptRunnerContext ctx, String directoryPath) {
        String navigationSign = directoryPath.substring(0, 1);
        String navigationValue = directoryPath.substring(1);
        if (this.isNumber(navigationValue)) {
            if (navigationSign.equals("+")) {
                directoryManager.navigateStack(ctx, directoryManager, directoryPath, directoryManager::pushPlus);
            } else if (navigationSign.equals("_")) {
                directoryManager.navigateStack(ctx, directoryManager, directoryPath, directoryManager::pushMinest);
            }
        } else {
            ctx.writeln(Messages.getString("PUSHD_PARAMETER_NOT_RECOGNIZED"));
        }
    }

    private boolean isNumber(String navigationValue) {
        return navigationValue.chars().allMatch(Character::isDigit);
    }

    private void handleRegularDirectory(DirectoryManager directoryManager, ScriptRunnerContext ctx, String directoryPath) {
        try {
            Optional<Path> validatedPath = FileUtils.validatePath(ctx, directoryPath);
            if (validatedPath.isEmpty()) {
                ctx.writeln(Messages.getString("DIRS_DIRECTORY_INVALID"));
                return;
            }
            Path newDir = validatedPath.get();
            if (!Files.isReadable(newDir) || !Files.isExecutable(newDir)) {
                ctx.writeln(Messages.getString("POPD_PERMISSION_DENIED_NAVIGATE" + newDir.toString()));
            }
            Path changedDir = FileUtils.changeDirectory(ctx, directoryPath);
            if (newDir == null) {
                ctx.writeln(Messages.getString("DIRS_DIRECTORY_NOT_FOUND"));
                return;
            }
            directoryManager.pushDirectory(changedDir.toString());
            directoryManager.printDirectories(ctx, directoryManager.getDirectories());
        }
        catch (NullPointerException e) {
            ctx.writeln(Messages.getString("DIRS_UNEXPECTED_ERROR" + e.getMessage()));
        }
        catch (IOException e) {
            ctx.writeln(e.getMessage());
        }
    }

    private boolean isDirectoriesEmpty(DirectoryManager directoryManager) {
        Deque<String> directories = directoryManager.getDirectories();
        return directories.isEmpty();
    }

    private String getPwd(ScriptRunnerContext ctx) {
        return Paths.get((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]).toString();
    }
}

