/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.importer.core.ImportDataFormatConfig;
import oracle.dbtools.raptor.utils.ToolLogger;

public class ImportWriteStream
extends ToolLogger {
    private FileOutputStream _badStream;
    private OutputStreamWriter _badStreamWriter;
    private File _badFile;
    private URL _badFileURL;
    private String _genDirPath;
    private String _badDirPath;
    private String _genFileName;
    private String _badFileName;
    private String _defaultDir;
    private boolean _isGenTemp;
    private String _encoding;

    public ImportWriteStream(OutputStreamWriter osWriter) throws IOException {
        super(osWriter);
    }

    public ImportWriteStream(FileOutputStream outputStream) throws IOException {
        super((OutputStream)outputStream);
    }

    public ImportWriteStream(File file) throws IOException {
        super(file);
    }

    public ImportWriteStream(File file, String encoding) throws IOException {
        super(file, encoding);
    }

    public ImportWriteStream(String importFileName, String encoding) throws IOException {
        this(importFileName, encoding, null, null);
    }

    public ImportWriteStream(String importFileName, String encoding, String genDirPath, String extension) throws IOException {
        super(importFileName, encoding, extension, genDirPath);
        this._encoding = encoding;
        if (genDirPath != null) {
            this._badDirPath = this._genDirPath = genDirPath;
        } else {
            this.init();
            this._genDirPath = this._defaultDir;
            this._badDirPath = this._defaultDir;
        }
        try {
            this.setGenFiles(importFileName, extension);
        }
        catch (IOException e) {
            this._badDirPath = this._genDirPath = ImportWriteStream.getTempDir();
            this.setGenFiles(importFileName, extension);
        }
    }

    private void setGenFiles(String importFileName) throws IOException {
        this.setGenFiles(importFileName, null);
    }

    private void setGenFiles(String importFileName, String extension) throws IOException {
        String ext = extension == null ? ".sql" : extension;
        String candidateFileName = importFileName;
        this._genFileName = this.getUniqueFileName(this._genDirPath, candidateFileName + "_" + this.getStartTime(), ext);
        this._badFileName = this.getUniqueFileName(this._badDirPath, candidateFileName + "-bad_" + this.getStartTime(), ext);
        this._badFile = new File(this._badFileName);
        this._badFileURL = this._badFile.toURI().toURL();
        if (this._isGenTemp) {
            // empty if block
        }
        if (this._encoding == null) {
            this._badStream = new FileOutputStream(this._badFile);
            this._badStreamWriter = new OutputStreamWriter(this._badStream);
        } else {
            this._badStream = new FileOutputStream(this._badFile);
            this._badStreamWriter = new OutputStreamWriter((OutputStream)this._badStream, this._encoding);
        }
        super.setWriter();
    }

    private void init() {
        IStorage config = ICommonConfig.Storage.getInstance();
        this._defaultDir = config.getString("IMPORT_INS_GEN_DIR");
        this._isGenTemp = config.getBoolean("IMPORT_INS_GEN_TEMP");
        if (this._defaultDir == null || this._defaultDir.length() == 0) {
            this._defaultDir = config.getString("IMPORTDIR");
            if (this._isGenTemp) {
                try {
                    this._defaultDir = ImportWriteStream.getTempDir();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected FileOutputStream getBadStream() {
        return this._badStream;
    }

    public OutputStreamWriter getBadStreamWriter() {
        return this._badStreamWriter;
    }

    public void endObject() {
    }

    public void endPreamble() {
    }

    public void finished() {
        super.finished();
    }

    public void finishedBad() throws IOException {
        if (this._badStreamWriter != null) {
            this._badStreamWriter.flush();
            this._badStreamWriter.close();
            this._badStreamWriter = null;
        }
        if (!this.isBadFileUsed()) {
            this.deleteEmptyBadFile();
        }
    }

    protected void printErrorSummary(String[] messages) throws IOException {
        OutputStreamWriter messageWriter = null;
        FileOutputStream fout = null;
        fout = new FileOutputStream(this.getFile(), false);
        messageWriter = this._encoding == null ? new OutputStreamWriter(fout) : new OutputStreamWriter((OutputStream)fout, this._encoding);
        this.finished();
        for (String message : messages) {
            messageWriter.write(message);
        }
        ((Writer)messageWriter).flush();
        ((Writer)messageWriter).close();
    }

    public void println(String toPrint) throws IOException {
        super.log(toPrint);
    }

    public void printlnBad(String toPrint) throws IOException {
        this._badStreamWriter.write(toPrint + "\n");
    }

    public boolean isBadFileUsed() {
        return this._badFile != null & this._badFile.exists() && this._badFile.length() > 0L;
    }

    public void deleteEmptyBadFile() {
        if (this._badFile != null && this._badFile.exists() && this._badFile.length() == 0L) {
            this._badFile.delete();
        }
    }

    public void startObject(String objectName, String objectType) {
    }

    public void startPreamble(String name) throws FileNotFoundException, UnsupportedEncodingException {
    }

    public void seturlBad(URL url) {
        this._badFileURL = url;
    }

    public URL geturlBad() {
        return this._badFileURL;
    }

    public String getFileName() {
        return this._genFileName;
    }

    public static String getTempDir() throws IOException {
        File tempFile = File.createTempFile("pref", "suf");
        String dirPath = tempFile.getParentFile().getPath();
        tempFile.delete();
        return dirPath;
    }

    private String getUniqueFileName(String dirPath, String candidateFileName, String extension) {
        String fileName = dirPath + File.separator + candidateFileName + extension;
        File candidateFile = new File(fileName);
        int suffix = 0;
        while (candidateFile.isFile()) {
            fileName = dirPath + File.separator + candidateFileName + "_" + ++suffix + extension;
            candidateFile = new File(fileName);
        }
        return fileName;
    }

    static {
        ImportDataFormatConfig.DefaultInitializer.init();
    }
}

