/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import java.io.InputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.cmdline.Messages;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.data.readservice.ReadParmsAPI;
import oracle.dbtools.data.readservice.ReadService;
import oracle.dbtools.data.readservice.ReadServiceBase;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.importer.readers.ReadParmsXLSAPI;

public class XLSReaderService
extends ReadServiceBase {
    private final Logger LOGGER = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected IDataReadable reader;

    private XLSReaderService(String fileName, String format) throws DataReaderException {
        this.reader = DataReaderRegistry.getReader(format);
        if (this.reader == null) {
            throw new DataReaderException(Messages.format("UNSUPPORTED_FORMAT", format));
        }
        this.reader.setFileName(fileName);
    }

    public String getType() {
        return this.reader.getType();
    }

    public String getFormat() {
        return this.reader.getFormat();
    }

    public String[] getColumnNames() {
        return this.reader.getColumnNames();
    }

    public String[] getDefaultColumnNames(int columnCount) {
        return this.reader.getDefaultColumnNames();
    }

    public int getColumnCount() {
        return this.reader.getColumnCount();
    }

    public void open() {
    }

    public void start() {
        try {
            this.reader.start();
        }
        catch (DataReaderException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public boolean hasMoreRows() {
        return this.reader.hasMoreRows();
    }

    public boolean hasMoreRows(int limit) {
        return false;
    }

    public Object[] readline() throws DataFormatException {
        return this.reader.readline();
    }

    public void close() {
    }

    public static ReadService.Builder builder(String fileName, String format) throws DataReaderException {
        return new Builder(fileName, format);
    }

    public static class Builder
    implements ReadService.Builder {
        private InputStream inputStream;
        private ReadParmsXLSAPI readParmsXLSAPI;
        private String fileName;
        private final String format;
        private final Logger LOGGER = Logger.getLogger(this.getClass().getName());

        public Builder(String fileName, String format) {
            this.fileName = fileName;
            this.format = format;
        }

        public ReadService build() {
            XLSReaderService readService = null;
            try {
                readService = new XLSReaderService(this.fileName, this.format);
            }
            catch (DataReaderException e) {
                this.LOGGER.log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
            }
            return readService;
        }

        public ReadService.Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public ReadService.Builder parms(ReadParmsAPI parms) {
            this.readParmsXLSAPI = (ReadParmsXLSAPI)parms;
            return this;
        }

        public ReadService.Builder fileName(String fileName) throws DataReaderException {
            this.fileName = fileName;
            return this;
        }

        public ReadService.Builder responseLocales(Iterable<Locale> responseLocales) {
            return this;
        }
    }
}

