/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.LogManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;

public class Workflow {
    private String name;
    private ParsedCommand command;
    private ScriptRunnerContext ctx;
    private Status status;
    private HashMap<String, Object> state;
    private Logger logger;
    private String logFile;
    private Connection conn;
    private List<UnitOfWork> steps;
    private static Parser parser;

    public Workflow(String name, ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this.name = name;
        this.command = command;
        this.conn = conn;
        this.ctx = ctx;
        this.status = Status.NOT_STARTED;
        String dbUniqueName = RCVCommand.getDbUniqueName(conn);
        this.logger = LogManager.getLogger(name, dbUniqueName);
        this.logFile = LogManager.getLogFile(name, dbUniqueName);
        this.state = new HashMap();
        this.steps = new ArrayList<UnitOfWork>();
    }

    public static Optional<ParsedCommand> generateParsedCommand(RCVVerbs verb, RCVObjects object, Map<String, String> options, List<String> flags, ScriptRunnerContext ctx) {
        if (parser == null) {
            parser = new Parser(RCVGrammar.createType(), ctx.getEnvironment());
        }
        StringBuilder rcvCommand = new StringBuilder(String.format("%s %s %s", new Object[]{RCVGrammar.Base.RCV, verb, object}));
        if (options != null) {
            for (String optionName : options.keySet()) {
                if (options.get(optionName) == null) continue;
                rcvCommand.append(String.format(" -%s %s", optionName, options.get(optionName)));
            }
        }
        if (flags != null) {
            for (String optionName : flags) {
                rcvCommand.append(" -");
                rcvCommand.append(optionName);
            }
        }
        return parser.parse(rcvCommand.toString(), arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0));
    }

    public void setSteps(List<UnitOfWork> steps) {
        this.steps = steps;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void initState() {
    }

    public String getName() {
        return this.name;
    }

    public ParsedCommand getCommand() {
        return this.command;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public ScriptRunnerContext getContext() {
        return this.ctx;
    }

    public Parser getParser() {
        if (parser == null) {
            parser = new Parser(RCVGrammar.createType(), this.ctx.getEnvironment());
        }
        return parser;
    }

    public void logException(Throwable e) {
        if (e == null) {
            return;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (this.logger == null) continue;
            this.logger.log(Level.INFO, Utils.getFirstString(cause.getMessage()));
            this.logger.log(Level.FINE, Utils.getStackTrace(cause));
        }
        if (this.logger != null) {
            this.logger.log(Level.INFO, Utils.getFirstString(e.getMessage()).replaceFirst("^Error: ", ""));
        }
    }

    public void logResult(Result result) {
        if (this.logger == null) {
            return;
        }
        if (result.getMessage() != null) {
            this.logger.log(Level.WARNING, Utils.getFirstString(result.getMessage()));
            String action = result.getAction();
            if (!action.isEmpty()) {
                this.logger.log(Level.WARNING, action);
            }
        }
    }

    public void handleFailure() {
    }

    public boolean isApplicable() {
        return true;
    }

    public Result run() {
        int numSteps = this.steps.size();
        boolean printProgress = numSteps > 1;
        try {
            this.initState();
        }
        catch (Exception e) {
            this.logException(e);
            return Result.wfInitError("Initialization failed.");
        }
        for (int i = 0; i < numSteps; ++i) {
            Result stepResult;
            Status status;
            UnitOfWork step = this.steps.get(i);
            if (printProgress) {
                String progress = String.format("Start - step %d of %d", i + 1, numSteps);
                this.logger.log(Level.INFO, progress);
            }
            if ((status = (stepResult = step.run()).getStatus()).equals((Object)Status.FAILED) || status.equals((Object)Status.TIMED_OUT)) {
                this.logger.log(Level.INFO, status.toString());
                return stepResult;
            }
            if (!printProgress) continue;
            this.logger.log(Level.INFO, status.toString());
            this.logger.log(Level.INFO, String.valueOf('-').repeat(50));
        }
        return new Result(Status.SUCCESS);
    }
}

