/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.controllers.ConfigurationManager;
import oracle.dbtools.extension.rcv.controllers.WalletManager;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.VpcUser;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class UpdateZRCVConfigurationWorkflow
extends ProtectedDatabaseWorkflow {
    private OracleWallet wallet;
    private ZRCVClientManager zrcvClientManager;

    public UpdateZRCVConfigurationWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("update configuration", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new UpdateConfiguration());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        Logger logger = this.getLogger();
        this.wallet = WalletManager.createWallet(metadata.getWalletLocation());
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(logger);
    }

    private String getVpcUserName() throws IOException {
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        String vpcUserName = metadata.getVpcUserName();
        if (vpcUserName == null) {
            vpcUserName = ConfigurationManager.getVpcUserName(ConfigurationManager.getRcvConf(metadata));
            if (vpcUserName == null) {
                ProtectedDatabase protectedDatabase = this.zrcvClientManager.getProtectedDatabase(metadata.getOcid());
                vpcUserName = protectedDatabase.getVpcUserName();
            }
            return vpcUserName;
        }
        return vpcUserName;
    }

    private class UpdateConfiguration
    implements UnitOfWork {
        private UpdateConfiguration() {
        }

        @Override
        public Result run() {
            String dbUniqueName = UpdateZRCVConfigurationWorkflow.this.getDbUniqueName();
            ProtectedDatabaseMetadata metadata = UpdateZRCVConfigurationWorkflow.this.getProtectedDatabaseMetadata();
            Logger logger = UpdateZRCVConfigurationWorkflow.this.getLogger();
            String configZipPath = metadata.getNetworkDirectory() + File.separatorChar + "config.zip";
            UpdateZRCVConfigurationWorkflow.this.zrcvClientManager.getConfiguration(metadata.getOcid(), FetchProtectedDatabaseConfigurationDetails.ConfigurationType.All, configZipPath);
            try {
                ConfigurationManager.updateClientConfiguration(configZipPath, metadata);
            }
            catch (IOException e) {
                UpdateZRCVConfigurationWorkflow.this.logException(e);
                return Result.wfUpdateClientConfError("Encountered error while updating client configuration.");
            }
            String rcvConfPath = ConfigurationManager.getRcvConf(metadata);
            List<Object> aliases = new ArrayList();
            ArrayList<String> missingAliases = new ArrayList<String>();
            try {
                aliases = ConfigurationManager.getWalletEntries(metadata);
            }
            catch (Exception e) {
                UpdateZRCVConfigurationWorkflow.this.logException(e);
                String string = String.format("Failed to get aliases for the recovery service from: %s", rcvConfPath);
                return Result.ucwGetAliasesError(string);
            }
            for (String string : aliases) {
                try {
                    if (WalletManager.walletContainsConnectString(UpdateZRCVConfigurationWorkflow.this.wallet, string)) continue;
                    missingAliases.add(string);
                }
                catch (Exception e) {
                    UpdateZRCVConfigurationWorkflow.this.logException(e);
                    return Result.ucwQueryWalletError("Failed to locate wallet alias!");
                }
            }
            if (!missingAliases.isEmpty()) {
                char[] cArray;
                String vpcUserName = null;
                try {
                    vpcUserName = UpdateZRCVConfigurationWorkflow.this.getVpcUserName();
                }
                catch (IOException iOException) {
                    return Result.ucwGetVpcUserError(iOException.getMessage());
                }
                if (vpcUserName == null) {
                    return Result.ucwGetVpcUserError("Failed to get VPC user name!");
                }
                metadata.setVpcUserName(vpcUserName);
                Object var9_14 = null;
                try {
                    cArray = WalletManager.getSecretForUser(UpdateZRCVConfigurationWorkflow.this.wallet, vpcUserName);
                }
                catch (IOException | OracleSecretStoreException e) {
                    return Result.ucwGetVpcUserPwdError(e.getMessage());
                }
                if (cArray != null) {
                    String password = new String(cArray);
                    VpcUser vpcUser = new VpcUser(vpcUserName, password);
                    for (String alias : missingAliases) {
                        try {
                            vpcUser.storePassword(UpdateZRCVConfigurationWorkflow.this.wallet, alias);
                        }
                        catch (Exception e) {
                            UpdateZRCVConfigurationWorkflow.this.logException(e);
                            String error = String.format("Fail to add new alias: %s to a wallet: %s", alias, UpdateZRCVConfigurationWorkflow.this.wallet.getLocation());
                            return Result.ucwUpdateVpcUserPwdError(error);
                        }
                    }
                } else {
                    String error = String.format("Failed to get password for VPC user %s. The VPC user is not in wallet %s", vpcUserName, metadata.getWalletLocation());
                    return Result.ucwGetVpcUserPwdError(error);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

